/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterAsKeyFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.PartitionStatusChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.PartitionStatusChangedEvent;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LocalEntryRetriever<K, V>
implements EntryRetriever<K, V> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final int batchSize;
    protected final long timeout;
    protected final TimeUnit unit;
    protected DataContainer<K, V> dataContainer;
    protected PersistenceManager persistenceManager;
    protected ExecutorService executorService;
    protected Cache<K, V> cache;
    protected ComponentRegistry componentRegistry;
    protected TimeService timeService;
    protected InternalEntryFactory entryFactory;
    protected Equivalence<K> keyEquivalence;
    protected final Executor withinThreadExecutor = new WithinThreadExecutor();
    protected final PartitionListener partitionListener = new PartitionListener();
    boolean passivationEnabled;

    @Inject
    public void inject(DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, @ComponentName(value="org.infinispan.executors.transport") ExecutorService executorService, TimeService timeService, InternalEntryFactory entryFactory, Cache<K, V> cache, Configuration config, ComponentRegistry componentRegistry) {
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.executorService = executorService;
        this.timeService = timeService;
        this.entryFactory = entryFactory;
        this.cache = cache;
        this.passivationEnabled = config.persistence().passivation();
        this.keyEquivalence = config.dataContainer().keyEquivalence();
        this.componentRegistry = componentRegistry;
    }

    @Start
    public void start() {
        this.cache.addListener(this.partitionListener);
    }

    public LocalEntryRetriever(int batchSize, long timeout, TimeUnit unit) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be greater than 0");
        }
        if (unit == null) {
            throw new NullPointerException("unit must not be null");
        }
        this.batchSize = batchSize;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public <C> void startRetrievingValues(UUID identifier, Address origin, Set<Integer> segments, Set<K> keysToFilter, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter, Set<Flag> flags) {
        throw new UnsupportedOperationException();
    }

    protected <C> void wireFilterAndConverterDependencies(KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter) {
        if (filter != null) {
            this.componentRegistry.wireDependencies(filter);
        }
        if (converter != null && converter != filter) {
            this.componentRegistry.wireDependencies(converter);
        }
    }

    @Override
    public <C> void receiveResponse(UUID identifier, Address origin, Set<Integer> completedSegments, Set<Integer> inDoubtSegments, Collection<CacheEntry<K, C>> entries, CacheException e) {
        throw new UnsupportedOperationException();
    }

    protected boolean shouldUseLoader(Set<Flag> flags) {
        return flags == null || !flags.contains((Object)Flag.SKIP_CACHE_LOAD);
    }

    protected <C> void registerIterator(Itr<C> itr, Set<Flag> flags) {
        if (flags == null || !flags.contains((Object)Flag.CACHE_MODE_LOCAL)) {
            this.partitionListener.iterators.add(itr);
            if (this.partitionListener.currentMode != AvailabilityMode.AVAILABLE) {
                this.partitionListener.iterators.remove(itr);
                throw this.log.partitionDegraded();
            }
        }
    }

    @Override
    public <C> CloseableIterator<CacheEntry<K, C>> retrieveEntries(final KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter, final Set<Flag> flags, EntryRetriever.SegmentListener listener) {
        Converter<? super K, ? super V, ? extends C> usedConverter;
        boolean filterAndConvert;
        if (filter instanceof KeyValueFilterConverter && (filter == converter || converter == null)) {
            filterAndConvert = true;
            usedConverter = null;
            if (this.log.isTraceEnabled()) {
                this.log.tracef("User supplied a KeyValueFilterConverter for both filter and converter, so ignoring converter", new Object[0]);
            }
        } else {
            filterAndConvert = false;
            usedConverter = converter;
        }
        this.wireFilterAndConverterDependencies(filter, usedConverter);
        if (flags != null && flags.contains((Object)Flag.SKIP_CACHE_LOAD) || !this.cache.getCacheConfiguration().persistence().usingStores()) {
            if (!(flags != null && flags.contains((Object)Flag.CACHE_MODE_LOCAL) || this.partitionListener.currentMode == AvailabilityMode.AVAILABLE)) {
                throw this.log.partitionDegraded();
            }
            Iterator iterator = this.dataContainer.iterator();
            return new DataContainerIterator<C>(iterator, filter, usedConverter, filterAndConvert);
        }
        final Itr iterator = new Itr(this.batchSize);
        this.registerIterator(iterator, flags);
        final ItrQueuerHandler handler = new ItrQueuerHandler(iterator);
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object converted;
                    final Set processedKeys = CollectionFactory.makeSet(LocalEntryRetriever.this.keyEquivalence);
                    ArrayDeque queue = new ArrayDeque<CacheEntry<K, C>>(LocalEntryRetriever.this.batchSize){

                        @Override
                        public boolean add(CacheEntry<K, C> kcEntry) {
                            processedKeys.add(kcEntry.getKey());
                            return super.add(kcEntry);
                        }
                    };
                    MapAction action = new MapAction(LocalEntryRetriever.this.batchSize, usedConverter, queue, handler);
                    PassivationListener listener = null;
                    long currentTime = LocalEntryRetriever.this.timeService.wallClockTime();
                    try {
                        int interruptCheck = 0;
                        for (InternalCacheEntry internalCacheEntry : LocalEntryRetriever.this.dataContainer) {
                            if (internalCacheEntry.isExpired(currentTime)) continue;
                            InternalCacheEntry clone = LocalEntryRetriever.this.entryFactory.create(LocalEntryRetriever.unwrapMarshalledvalue(internalCacheEntry.getKey()), LocalEntryRetriever.unwrapMarshalledvalue(internalCacheEntry.getValue()), internalCacheEntry);
                            Object key = clone.getKey();
                            if (filter != null) {
                                if (filterAndConvert) {
                                    converted = ((KeyValueFilterConverter)filter).filterAndConvert(key, clone.getValue(), clone.getMetadata());
                                    if (converted == null) continue;
                                    clone.setValue(converted);
                                } else if (!filter.accept(key, clone.getValue(), clone.getMetadata())) continue;
                            }
                            action.accept(key, clone);
                            if (interruptCheck++ % LocalEntryRetriever.this.batchSize != 0 || !Thread.interrupted()) continue;
                            throw new CacheException("Entry Iterator was interrupted!");
                        }
                        if (LocalEntryRetriever.this.shouldUseLoader(flags) && LocalEntryRetriever.this.persistenceManager.getStoresAsString().size() > 0) {
                            if (LocalEntryRetriever.this.passivationEnabled) {
                                listener = new PassivationListener();
                                LocalEntryRetriever.this.cache.addListener(listener);
                            }
                            KeyFilter loaderFilter = filter == null || filterAndConvert ? new CollectionKeyFilter(processedKeys) : new CompositeKeyFilter(new CollectionKeyFilter(processedKeys), new KeyValueFilterAsKeyFilter(filter));
                            if (filterAndConvert) {
                                action = new MapAction(LocalEntryRetriever.this.batchSize, (KeyValueFilterConverter)filter, queue, handler);
                            }
                            LocalEntryRetriever.this.persistenceManager.processOnAllStores(LocalEntryRetriever.this.withinThreadExecutor, loaderFilter, new KeyValueActionForCacheLoaderTask(action), true, true);
                        }
                    }
                    finally {
                        if (listener != null) {
                            LocalEntryRetriever.this.cache.removeListener(listener);
                            AdvancedCache advancedCache = LocalEntryRetriever.this.cache.getAdvancedCache();
                            for (Object object : listener.activatedKeys) {
                                CacheEntry entry;
                                if (processedKeys.contains(object) || (entry = advancedCache.getCacheEntry(object)) == null) continue;
                                CacheEntry clone = entry.clone();
                                if (filter != null) {
                                    if (filterAndConvert) {
                                        converted = ((KeyValueFilterConverter)filter).filterAndConvert(object, clone.getValue(), clone.getMetadata());
                                        if (converted == null) continue;
                                        clone.setValue(converted);
                                    } else if (!filter.accept(object, clone.getValue(), clone.getMetadata())) continue;
                                }
                                action.accept(clone.getKey(), clone);
                            }
                        }
                    }
                    if (LocalEntryRetriever.this.log.isTraceEnabled()) {
                        LocalEntryRetriever.this.log.trace("Completed transfer of entries from cache");
                    }
                    handler.handleBatch(true, queue);
                    LocalEntryRetriever.this.partitionListener.iterators.remove(iterator);
                }
                catch (Throwable t) {
                    CacheException e = LocalEntryRetriever.this.log.exceptionProcessingEntryRetrievalValues(t);
                    iterator.close(e);
                }
            }
        });
        return iterator;
    }

    protected static <T> T unwrapMarshalledvalue(T value) {
        if (value instanceof MarshalledValue) {
            return (T)((MarshalledValue)value).get();
        }
        return value;
    }

    protected class Itr<C>
    implements CloseableIterator<CacheEntry<K, C>> {
        private final BlockingQueue<CacheEntry<K, C>> queue;
        private final Lock nextLock = new ReentrantLock();
        private final Condition nextCondition = this.nextLock.newCondition();
        private boolean completed;
        private CacheException exception;

        public Itr(int batchSize) {
            this.queue = new ArrayBlockingQueue(batchSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = !this.queue.isEmpty();
            if (!hasNext) {
                boolean interrupted = false;
                long targetTime = LocalEntryRetriever.this.timeService.expectedEndTime(LocalEntryRetriever.this.timeout, LocalEntryRetriever.this.unit);
                this.nextLock.lock();
                try {
                    while (!(hasNext = !this.queue.isEmpty()) && !this.completed) {
                        try {
                            if (this.nextCondition.await(LocalEntryRetriever.this.timeService.remainingTime(targetTime, TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS)) continue;
                            if (LocalEntryRetriever.this.log.isTraceEnabled()) {
                                LocalEntryRetriever.this.log.tracef("Did not retrieve entries in allotted timeout: %s units: unit", (Object)LocalEntryRetriever.this.timeout, (Object)LocalEntryRetriever.this.unit);
                            }
                            throw new TimeoutException("Did not retrieve entries in allotted timeout: " + LocalEntryRetriever.this.timeout + " units: " + (Object)((Object)LocalEntryRetriever.this.unit));
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    if (!hasNext && this.exception != null) {
                        throw this.exception;
                    }
                }
                finally {
                    this.nextLock.unlock();
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return hasNext;
        }

        @Override
        public CacheEntry<K, C> next() {
            CacheEntry entry = (CacheEntry)this.queue.poll();
            if (entry == null) {
                if (this.completed) {
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    throw new NoSuchElementException();
                }
                this.nextLock.lock();
                try {
                    while ((entry = (CacheEntry)this.queue.poll()) == null && !this.completed) {
                        try {
                            this.nextCondition.await();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (entry == null) {
                        if (this.exception != null) {
                            throw this.exception;
                        }
                        throw new NoSuchElementException();
                    }
                }
                finally {
                    this.nextLock.unlock();
                }
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEntries(Collection<CacheEntry<K, C>> entries) throws InterruptedException {
            boolean wasCompleted = this.completed;
            Iterator itr = entries.iterator();
            while (!wasCompleted && itr.hasNext()) {
                CacheEntry entry = null;
                while (itr.hasNext() && this.queue.offer(entry = itr.next())) {
                    entry = null;
                }
                this.nextLock.lock();
                try {
                    wasCompleted = this.completed;
                    this.nextCondition.signalAll();
                }
                finally {
                    this.nextLock.unlock();
                }
                if (entry == null) continue;
                while (!wasCompleted && !this.queue.offer(entry, 100L, TimeUnit.MILLISECONDS)) {
                    this.nextLock.lock();
                    try {
                        wasCompleted = this.completed;
                    }
                    finally {
                        this.nextLock.unlock();
                    }
                }
            }
        }

        @Override
        public void close() {
            this.close(null);
        }

        protected void close(CacheException e) {
            this.nextLock.lock();
            try {
                if (!this.completed) {
                    this.exception = e;
                    this.completed = true;
                }
                this.nextCondition.signalAll();
            }
            finally {
                this.nextLock.unlock();
            }
        }
    }

    protected class ItrQueuerHandler<C>
    implements BatchHandler<K, C> {
        final Itr<C> iterator;

        public ItrQueuerHandler(Itr<C> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void handleBatch(boolean complete, Collection<CacheEntry<K, C>> entries) throws InterruptedException {
            this.iterator.addEntries(entries);
            if (complete) {
                this.iterator.close();
            }
        }
    }

    protected class DataContainerIterator<C>
    implements CloseableIterator<CacheEntry<K, C>> {
        private CacheEntry<K, C> next;
        private CacheEntry<K, C> prev;
        private final Iterator<InternalCacheEntry<K, V>> iterator;
        private final KeyValueFilter<? super K, ? super V> filter;
        private final Converter<? super K, ? super V, ? extends C> converter;
        private final boolean filterAndConvert;

        public DataContainerIterator(Iterator<InternalCacheEntry<K, V>> iterator, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter, boolean filterAndConvert) {
            this.iterator = iterator;
            this.filter = filter;
            this.converter = converter;
            this.filterAndConvert = filterAndConvert;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean hasNext() {
            while (this.next == null && this.iterator.hasNext()) {
                C newValue;
                void var4_4;
                InternalCacheEntry entry;
                block11: {
                    Object key;
                    void var4_7;
                    block12: {
                        entry = this.iterator.next();
                        if (LocalEntryRetriever.this.log.isTraceEnabled()) {
                            LocalEntryRetriever.this.log.tracef("Object [%s] returned from iteration - need to check if filtered", (Object)entry);
                        }
                        if (entry.isExpired(LocalEntryRetriever.this.timeService.wallClockTime())) {
                            if (!LocalEntryRetriever.this.log.isTraceEnabled()) continue;
                            LocalEntryRetriever.this.log.tracef("Object [%s] was expired, not returning", (Object)entry);
                            continue;
                        }
                        Object marshalledKey = LocalEntryRetriever.unwrapMarshalledvalue(entry.getKey());
                        Object marshalledValue = LocalEntryRetriever.unwrapMarshalledvalue(entry.getValue());
                        if (marshalledKey != entry.getKey() || marshalledValue != entry.getValue()) {
                            InternalCacheEntry internalCacheEntry = LocalEntryRetriever.this.entryFactory.create(marshalledKey, marshalledValue, entry);
                        } else {
                            InternalCacheEntry internalCacheEntry = entry;
                        }
                        if (this.filter == null) break block11;
                        key = var4_7.getKey();
                        if (!this.filterAndConvert) break block12;
                        Object converted = ((KeyValueFilterConverter)this.filter).filterAndConvert(key, var4_7.getValue(), var4_7.getMetadata());
                        if (converted != null) {
                            if (entry == var4_7) {
                                InternalCacheEntry internalCacheEntry = LocalEntryRetriever.this.entryFactory.create(var4_7.getKey(), converted, entry);
                                break block11;
                            } else {
                                var4_7.setValue(converted);
                            }
                            break block11;
                        } else {
                            if (!LocalEntryRetriever.this.log.isTraceEnabled()) continue;
                            LocalEntryRetriever.this.log.tracef("Object [%s] was filtered by KeyValueFilterConverter, not returning", (Object)var4_7);
                            continue;
                        }
                    }
                    if (!this.filter.accept(key, var4_7.getValue(), var4_7.getMetadata())) {
                        if (!LocalEntryRetriever.this.log.isTraceEnabled()) continue;
                        LocalEntryRetriever.this.log.tracef("Object [%s] was filtered, not returning", (Object)var4_7);
                        continue;
                    }
                }
                this.next = var4_4;
                if (this.converter == null || (newValue = this.converter.convert(var4_4.getKey(), var4_4.getValue(), var4_4.getMetadata())) == var4_4.getValue()) continue;
                if (entry == var4_4) {
                    this.next = LocalEntryRetriever.this.entryFactory.create(var4_4.getKey(), newValue, entry);
                    continue;
                }
                this.next.setValue(newValue);
            }
            if (this.next == null) return false;
            return true;
        }

        @Override
        public CacheEntry<K, C> next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            CacheEntry returnEntry = this.next;
            this.next = null;
            this.prev = returnEntry;
            return returnEntry;
        }

        @Override
        public void remove() {
            LocalEntryRetriever.this.cache.remove(this.prev.getKey());
        }

        @Override
        public void close() {
        }
    }

    protected static interface BatchHandler<K, C> {
        public void handleBatch(boolean var1, Collection<CacheEntry<K, C>> var2) throws InterruptedException;
    }

    private class MapAction<C>
    implements BiConsumer<K, CacheEntry<K, V>> {
        final Converter<? super K, ? super V, ? extends C> converter;
        final Queue<CacheEntry<K, C>> queue;
        final int batchSize;
        final BatchHandler<K, C> handler;
        final AtomicInteger insertionCount = new AtomicInteger();

        public MapAction(int batchSize, Converter<? super K, ? super V, ? extends C> converter, Queue<CacheEntry<K, C>> queue, BatchHandler<K, C> handler) {
            this.batchSize = batchSize;
            this.converter = converter;
            this.queue = queue;
            this.handler = handler;
        }

        @Override
        public void accept(K k, CacheEntry<K, V> kvInternalCacheEntry) {
            CacheEntry clone = kvInternalCacheEntry.clone();
            if (this.converter != null) {
                C value = this.converter.convert(k, kvInternalCacheEntry.getValue(), kvInternalCacheEntry.getMetadata());
                if (value == null && this.converter instanceof KeyValueFilterConverter) {
                    return;
                }
                clone.setValue(value);
            }
            this.queue.add(clone);
            if (this.insertionCount.incrementAndGet() % this.batchSize == 0) {
                try {
                    this.handler.handleBatch(false, this.queue);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.queue.clear();
            }
        }
    }

    protected class KeyValueActionForCacheLoaderTask
    implements AdvancedCacheLoader.CacheLoaderTask<K, V> {
        private final BiConsumer<? super K, ? super InternalCacheEntry<K, V>> action;

        public KeyValueActionForCacheLoaderTask(BiConsumer<? super K, ? super InternalCacheEntry<K, V>> action) {
            this.action = action;
        }

        @Override
        public void processEntry(MarshalledEntry<K, V> marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
            if (!taskContext.isStopped()) {
                InternalMetadata metadata = marshalledEntry.getMetadata();
                if (metadata == null || !metadata.isExpired(LocalEntryRetriever.this.timeService.wallClockTime())) {
                    InternalCacheEntry ice = PersistenceUtil.convert(marshalledEntry, LocalEntryRetriever.this.entryFactory);
                    this.action.accept(marshalledEntry.getKey(), ice);
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    @Listener
    protected static class PassivationListener<K, V> {
        Queue<K> activatedKeys = new ConcurrentLinkedQueue<K>();

        protected PassivationListener() {
        }

        @CacheEntryActivated
        public void onEntryActivated(CacheEntryActivatedEvent<K, V> activatedEvent) {
            this.activatedKeys.add(activatedEvent.getKey());
        }
    }

    @Listener
    protected class PartitionListener {
        protected volatile AvailabilityMode currentMode = AvailabilityMode.AVAILABLE;
        protected final Set<Itr<?>> iterators = new ConcurrentHashSet();

        protected PartitionListener() {
        }

        @PartitionStatusChanged
        public void onPartitionChange(PartitionStatusChangedEvent<K, V> event) {
            if (!event.isPre()) {
                this.currentMode = event.getAvailabilityMode();
                if (this.currentMode != AvailabilityMode.AVAILABLE) {
                    Iterator<Itr<?>> itrIterator = this.iterators.iterator();
                    while (itrIterator.hasNext()) {
                        Itr<?> itr = itrIterator.next();
                        itr.close(new AvailabilityException());
                        itrIterator.remove();
                    }
                }
            }
        }
    }
}

