/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.RemoteFetchingCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GetKeyValueCommand
extends AbstractDataCommand
implements RemoteFetchingCommand {
    public static final byte COMMAND_ID = 4;
    private static final Log log = LogFactory.getLog(GetKeyValueCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private InternalCacheEntry remotelyFetchedValue;

    public GetKeyValueCommand(Object key, Set<Flag> flags) {
        this.key = key;
        this.flags = flags;
    }

    public GetKeyValueCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeyValueCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        InternalCacheEntry ice;
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null || entry.isNull()) {
            if (trace) {
                log.trace("Entry not found");
            }
            return null;
        }
        if (entry.isRemoved()) {
            if (trace) {
                log.tracef("Entry has been deleted and is of type %s", (Object)entry.getClass().getSimpleName());
            }
            return null;
        }
        if (entry instanceof InternalCacheEntry && (ice = (InternalCacheEntry)entry).isL1Entry()) {
            this.setRemotelyFetchedValue(ice);
        }
        return entry.getValue();
    }

    @Override
    public byte getCommandId() {
        return 4;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 4) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.flags = (Set)parameters[1];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public void setRemotelyFetchedValue(InternalCacheEntry remotelyFetchedValue) {
        this.remotelyFetchedValue = remotelyFetchedValue;
    }

    @Override
    public InternalCacheEntry getRemotelyFetchedValue() {
        return this.remotelyFetchedValue;
    }

    @Override
    public String toString() {
        return "GetKeyValueCommand {key=" + Util.toStr(this.key) + ", flags=" + this.flags + "}";
    }
}

