/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private CommandsFactory cf;
    private StateTransferManager stateTransferManager;
    private static final Log log = LogFactory.getLog(PessimisticLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(CommandsFactory factory, StateTransferManager stateTransferManager) {
        this.cf = factory;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    protected final Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        try {
            if (ctx.isInTxScope() && command.hasFlag(Flag.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command)) {
                this.acquireRemoteIfNeeded(ctx, command, this.cdl.localNodeIsPrimaryOwner(command.getKey()));
                long lockTimeout = this.getLockAcquisitionTimeout(command, false);
                this.lockKeyAndCheckOwnership(ctx, command.getKey(), lockTimeout, false);
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable t) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        try {
            if (ctx.isInTxScope() && command.hasFlag(Flag.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command)) {
                this.acquireRemoteIfNeeded(ctx, command.getKeys(), command);
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                long lockTimeout = this.getLockAcquisitionTimeout(command, false);
                for (Object key : command.getKeys()) {
                    this.lockAndRegisterBackupLock(txContext, key, lockTimeout, false);
                }
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable t) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t;
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.invokeNextAndCommitIf1Pc(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                this.acquireRemoteIfNeeded(ctx, command.getMap().keySet(), command);
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                long lockTimeout = this.getLockAcquisitionTimeout(command, false);
                for (Object key : command.getMap().keySet()) {
                    this.lockAndRegisterBackupLock(txContext, key, lockTimeout, false);
                }
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                boolean localLock = this.cdl.localNodeIsPrimaryOwner(command.getKey());
                this.acquireRemoteIfNeeded(ctx, command, localLock);
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                long lockTimeout = this.getLockAcquisitionTimeout(command, false);
                this.lockAndRegisterBackupLock(txContext, command.getKey(), localLock, lockTimeout, false);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (OutdatedTopologyException e) {
            throw e;
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        Object[] compositeKeys = command.getCompositeKeys();
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                HashSet<Object> keysToLock = new HashSet<Object>(Arrays.asList(compositeKeys));
                this.acquireRemoteIfNeeded(ctx, keysToLock, command);
                if (this.cdl.localNodeIsOwner(command.getKey())) {
                    long lockTimeout = this.getLockAcquisitionTimeout(command, false);
                    for (Object key : compositeKeys) {
                        this.lockKey(ctx, key, lockTimeout, false);
                    }
                }
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("Locks should only be acquired within the scope of a transaction!");
        }
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (skipLocking) {
                return this.invokeNextInterceptor(ctx, command);
            }
            if (ctx.isOriginLocal()) {
                boolean needBackupLocks;
                boolean isSingleKeyAndLocal = !command.multipleKeys() && this.cdl.localNodeIsPrimaryOwner(command.getSingleKey());
                boolean bl = needBackupLocks = !isSingleKeyAndLocal || this.isStateTransferInProgress();
                if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                    LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
                    if (!localTx.getAffectedKeys().containsAll(command.getKeys())) {
                        this.invokeNextInterceptor(ctx, command);
                    } else {
                        log.tracef("Already own locks on keys: %s, skipping remote call", (Object)command.getKeys());
                    }
                }
                ctx.addAllAffectedKeys(command.getKeys());
            }
            if (command.isUnlock()) {
                if (ctx.isOriginLocal()) {
                    throw new AssertionError((Object)"There's no advancedCache.unlock so this must have originated remotely.");
                }
                this.releaseLocksOnFailureBeforePrepare(ctx);
                return Boolean.FALSE;
            }
            long lockTimeout = this.getLockAcquisitionTimeout(command, false);
            for (Object key : command.getKeys()) {
                this.lockAndRegisterBackupLock(ctx, key, lockTimeout, false);
            }
            return Boolean.TRUE;
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    private void acquireRemoteIfNeeded(InvocationContext ctx, Collection<?> keys, FlagAffectedCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            if (localTransaction.getAffectedKeys().containsAll(keys)) {
                log.tracef("We already have lock for keys %s, skip remote lock acquisition", (Object)keys);
                return;
            }
            LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlags(), txContext.getGlobalTransaction());
            this.invokeNextInterceptor(ctx, lcc);
        }
        ((TxInvocationContext)ctx).addAllAffectedKeys(keys);
    }

    private void acquireRemoteIfNeeded(InvocationContext ctx, DataCommand command, boolean localNodeIsLockOwner) throws Throwable {
        boolean needBackupLocks;
        Object key = command.getKey();
        boolean bl = needBackupLocks = ctx.isOriginLocal() && (!localNodeIsLockOwner || this.isStateTransferInProgress());
        if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean alreadyLocked = localTransaction.getAffectedKeys().contains(key);
            if (alreadyLocked) {
                log.tracef("We already have lock for key %s, skip remote lock acquisition", key);
                return;
            }
            LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlags(), txContext.getGlobalTransaction());
            this.invokeNextInterceptor(ctx, lcc);
        }
        ((TxInvocationContext)ctx).addAffectedKey(key);
    }

    private boolean isStateTransferInProgress() {
        return this.stateTransferManager != null && this.stateTransferManager.isStateTransferInProgress();
    }

    private void releaseLocksOnFailureBeforePrepare(InvocationContext ctx) {
        this.lockManager.unlockAll(ctx);
        if (ctx.isOriginLocal() && ctx.isInTxScope() && this.rpcManager != null) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            TxCompletionNotificationCommand command = this.cf.buildTxCompletionNotificationCommand(null, txContext.getGlobalTransaction());
            LocalTransaction cacheTransaction = (LocalTransaction)txContext.getCacheTransaction();
            this.rpcManager.invokeRemotely(cacheTransaction.getRemoteLocksAcquired(), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE));
        }
    }

    private void lockAndRegisterBackupLock(TxInvocationContext ctx, Object key, boolean isLockOwner, long lockTimeout, boolean skipLocking) throws InterruptedException {
        if (isLockOwner) {
            this.lockKeyAndCheckOwnership(ctx, key, lockTimeout, skipLocking);
        } else if (this.cdl.localNodeIsOwner(key)) {
            ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
        }
    }
}

