/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;

public class TransactionConfiguration {
    public static final AttributeDefinition<Boolean> AUTO_COMMIT = AttributeDefinition.builder("autoCommit", true).immutable().build();
    public static final AttributeDefinition<Long> CACHE_STOP_TIMEOUT = AttributeDefinition.builder("cacheStopTimeout", TimeUnit.SECONDS.toMillis(30L)).build();
    public static final AttributeDefinition<Boolean> EAGER_LOCKING_SINGLE_NODE = AttributeDefinition.builder("eagerLockingSingleNode", false).immutable().build();
    public static final AttributeDefinition<LockingMode> LOCKING_MODE = AttributeDefinition.builder("lockingMode", LockingMode.OPTIMISTIC).build();
    public static final AttributeDefinition<Boolean> SYNC_COMMIT_PHASE = AttributeDefinition.builder("syncCommitPhase", true).immutable().build();
    public static final AttributeDefinition<Boolean> SYNC_ROLLBACK_PHASE = AttributeDefinition.builder("syncRollbackPhase", true).immutable().build();
    public static final AttributeDefinition<TransactionManagerLookup> TRANSACTION_MANAGER_LOOKUP = AttributeDefinition.builder("transactionManagerLookup", GenericTransactionManagerLookup.INSTANCE).copier(IdentityAttributeCopier.INSTANCE).build();
    public static final AttributeDefinition<TransactionSynchronizationRegistryLookup> TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = AttributeDefinition.builder("transactionSynchronizationRegistryLookup", null, TransactionSynchronizationRegistryLookup.class).copier(IdentityAttributeCopier.INSTANCE).build();
    public static final AttributeDefinition<TransactionMode> TRANSACTION_MODE = AttributeDefinition.builder("transactionMode", TransactionMode.NON_TRANSACTIONAL).immutable().build();
    public static final AttributeDefinition<Boolean> USE_EAGER_LOCKING = AttributeDefinition.builder("useEagerLocking", false).build();
    public static final AttributeDefinition<Boolean> USE_SYNCHRONIZATION = AttributeDefinition.builder("useSynchronization", false).immutable().build();
    public static final AttributeDefinition<Boolean> USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS = AttributeDefinition.builder("use1PcForAutoCommitTransactions", false).build();
    public static final AttributeDefinition<Long> REAPER_WAKE_UP_INTERVAL = AttributeDefinition.builder("reaperWakeUpInterval", 30000L).immutable().build();
    public static final AttributeDefinition<Long> COMPLETED_TX_TIMEOUT = AttributeDefinition.builder("completedTxTimeout", 60000L).immutable().build();
    public static final AttributeDefinition<TransactionProtocol> TRANSACTION_PROTOCOL = AttributeDefinition.builder("transactionProtocol", TransactionProtocol.DEFAULT).immutable().build();
    private final Attribute<Boolean> autoCommit;
    private final Attribute<Long> cacheStopTimeout;
    private final Attribute<Boolean> eagerLockingSingleNode;
    private final Attribute<LockingMode> lockingMode;
    private final Attribute<Boolean> syncCommitPhase;
    private final Attribute<Boolean> syncRollbackPhase;
    private final Attribute<TransactionManagerLookup> transactionManagerLookup;
    private final Attribute<TransactionSynchronizationRegistryLookup> transactionSynchronizationRegistryLookup;
    private final Attribute<TransactionMode> transactionMode;
    private final Attribute<Boolean> useEagerLocking;
    private final Attribute<Boolean> useSynchronization;
    private final Attribute<Boolean> use1PcForAutoCommitTransactions;
    private final Attribute<Long> reaperWakeUpInterval;
    private final Attribute<Long> completedTxTimeout;
    private final Attribute<TransactionProtocol> transactionProtocol;
    private final AttributeSet attributes;
    private final RecoveryConfiguration recovery;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TransactionConfiguration.class, AUTO_COMMIT, CACHE_STOP_TIMEOUT, EAGER_LOCKING_SINGLE_NODE, LOCKING_MODE, SYNC_COMMIT_PHASE, SYNC_ROLLBACK_PHASE, TRANSACTION_MANAGER_LOOKUP, TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP, TRANSACTION_MODE, USE_EAGER_LOCKING, USE_SYNCHRONIZATION, USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS, REAPER_WAKE_UP_INTERVAL, COMPLETED_TX_TIMEOUT, TRANSACTION_PROTOCOL);
    }

    TransactionConfiguration(AttributeSet attributes, RecoveryConfiguration recovery) {
        this.attributes = attributes.checkProtection();
        this.autoCommit = attributes.attribute(AUTO_COMMIT);
        this.cacheStopTimeout = attributes.attribute(CACHE_STOP_TIMEOUT);
        this.eagerLockingSingleNode = attributes.attribute(EAGER_LOCKING_SINGLE_NODE);
        this.lockingMode = attributes.attribute(LOCKING_MODE);
        this.syncCommitPhase = attributes.attribute(SYNC_COMMIT_PHASE);
        this.syncRollbackPhase = attributes.attribute(SYNC_ROLLBACK_PHASE);
        this.transactionManagerLookup = attributes.attribute(TRANSACTION_MANAGER_LOOKUP);
        this.transactionSynchronizationRegistryLookup = attributes.attribute(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
        this.transactionMode = attributes.attribute(TRANSACTION_MODE);
        this.useEagerLocking = attributes.attribute(USE_EAGER_LOCKING);
        this.useSynchronization = attributes.attribute(USE_SYNCHRONIZATION);
        this.use1PcForAutoCommitTransactions = attributes.attribute(USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS);
        this.reaperWakeUpInterval = attributes.attribute(REAPER_WAKE_UP_INTERVAL);
        this.completedTxTimeout = attributes.attribute(COMPLETED_TX_TIMEOUT);
        this.transactionProtocol = attributes.attribute(TRANSACTION_PROTOCOL);
        this.recovery = recovery;
    }

    public boolean autoCommit() {
        return this.autoCommit.get();
    }

    public TransactionConfiguration cacheStopTimeout(long l) {
        this.cacheStopTimeout.set(l);
        return this;
    }

    public long cacheStopTimeout() {
        return this.cacheStopTimeout.get();
    }

    @Deprecated
    public boolean eagerLockingSingleNode() {
        return this.eagerLockingSingleNode.get();
    }

    public LockingMode lockingMode() {
        return this.lockingMode.get();
    }

    public TransactionConfiguration lockingMode(LockingMode lockingMode) {
        this.lockingMode.set(lockingMode);
        return this;
    }

    public boolean syncCommitPhase() {
        return this.syncCommitPhase.get();
    }

    @Deprecated
    public TransactionConfiguration syncCommitPhase(boolean b) {
        return this;
    }

    public boolean syncRollbackPhase() {
        return this.syncRollbackPhase.get();
    }

    @Deprecated
    public TransactionConfiguration syncRollbackPhase(boolean b) {
        return this;
    }

    public TransactionManagerLookup transactionManagerLookup() {
        return this.transactionManagerLookup.get();
    }

    public TransactionConfiguration transactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transactionManagerLookup.set(transactionManagerLookup);
        return this;
    }

    public TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup() {
        return this.transactionSynchronizationRegistryLookup.get();
    }

    public TransactionMode transactionMode() {
        return this.transactionMode.get();
    }

    @Deprecated
    public boolean useEagerLocking() {
        return this.useEagerLocking.get();
    }

    @Deprecated
    public TransactionConfiguration useEagerLocking(boolean b) {
        this.useEagerLocking.set(b);
        return this;
    }

    public boolean useSynchronization() {
        return this.useSynchronization.get();
    }

    public RecoveryConfiguration recovery() {
        return this.recovery;
    }

    public long reaperWakeUpInterval() {
        return this.reaperWakeUpInterval.get();
    }

    public long completedTxTimeout() {
        return this.completedTxTimeout.get();
    }

    public boolean use1PcForAutoCommitTransactions() {
        return this.use1PcForAutoCommitTransactions.get();
    }

    public TransactionProtocol transactionProtocol() {
        return this.transactionProtocol.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "TransactionConfiguration [attributes=" + this.attributes + ", recovery=" + this.recovery + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionConfiguration other = (TransactionConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.recovery == null ? other.recovery != null : !this.recovery.equals(other.recovery));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.recovery == null ? 0 : this.recovery.hashCode());
        return result;
    }
}

