/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BlockingTaskAwareExecutorServiceImpl
extends AbstractExecutorService
implements BlockingTaskAwareExecutorService {
    private static final Log log = LogFactory.getLog(BlockingTaskAwareExecutorServiceImpl.class);
    private final BlockingQueue<BlockingRunnable> blockedTasks = new LinkedBlockingQueue<BlockingRunnable>();
    private final ExecutorService executorService;
    private final TimeService timeService;
    private volatile boolean shutdown;

    public BlockingTaskAwareExecutorServiceImpl(ExecutorService executorService, TimeService timeService) {
        this.executorService = executorService;
        this.timeService = timeService;
        this.shutdown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(BlockingRunnable runnable) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Executor Service is already shutdown");
        }
        if (runnable.isReady()) {
            this.doExecute(runnable);
        } else {
            boolean checkPendingTasks;
            this.blockedTasks.offer(runnable);
            BlockingQueue<BlockingRunnable> blockingQueue = this.blockedTasks;
            synchronized (blockingQueue) {
                checkPendingTasks = runnable.isReady();
            }
            if (checkPendingTasks) {
                this.checkForReadyTasks();
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Added a new task: %s task(s) are waiting", (Object)this.blockedTasks.size());
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        LinkedList<Runnable> runnableList = new LinkedList<Runnable>();
        runnableList.addAll(this.executorService.shutdownNow());
        runnableList.addAll(this.blockedTasks);
        return runnableList;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown && this.blockedTasks.isEmpty() && this.executorService.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTime = this.timeService.expectedEndTime(timeout, unit);
        BlockingQueue<BlockingRunnable> blockingQueue = this.blockedTasks;
        synchronized (blockingQueue) {
            long waitTime = this.timeService.remainingTime(endTime, TimeUnit.MILLISECONDS);
            while (!this.blockedTasks.isEmpty() && waitTime > 0L) {
                this.wait(waitTime);
            }
        }
        return this.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkForReadyTasks() {
        ArrayList<BlockingRunnable> runnableReadyList = new ArrayList<BlockingRunnable>(this.blockedTasks.size());
        BlockingQueue<BlockingRunnable> blockingQueue = this.blockedTasks;
        synchronized (blockingQueue) {
            Iterator iterator = this.blockedTasks.iterator();
            while (iterator.hasNext()) {
                BlockingRunnable runnable = (BlockingRunnable)iterator.next();
                if (!runnable.isReady()) continue;
                iterator.remove();
                runnableReadyList.add(runnable);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Tasks executed=%s, still pending=%s", (Object)runnableReadyList.size(), (Object)this.blockedTasks.size());
        }
        for (BlockingRunnable runnable : runnableReadyList) {
            this.doExecute(runnable);
        }
    }

    @Override
    public void execute(Runnable command) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Executor Service is already shutdown");
        }
        this.executorService.execute(command);
    }

    private void doExecute(BlockingRunnable runnable) {
        try {
            this.executorService.execute(runnable);
        }
        catch (RejectedExecutionException rejected) {
            this.blockedTasks.offer(runnable);
        }
    }
}

