/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.infinispan.cdi.InfinispanExtension;
import org.infinispan.cdi.InfinispanExtensionEmbedded;
import org.infinispan.cdi.util.BeanManagerProvider;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.jcache.annotation.Contracts;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

@ApplicationScoped
public class InjectedCacheResolver
implements CacheResolver {
    private EmbeddedCacheManager defaultCacheManager;
    private final Map<EmbeddedCacheManager, JCacheManager> jcacheManagers = new HashMap<EmbeddedCacheManager, JCacheManager>();
    private JCacheManager defaultJCacheManager;

    private EmbeddedCacheManager getDefaultCacheManager() {
        if (this.defaultCacheManager == null) {
            this.defaultCacheManager = this.getBeanReference(EmbeddedCacheManager.class);
        }
        return this.defaultCacheManager;
    }

    private JCacheManager getDefaultJCacheManager() {
        return this.defaultJCacheManager;
    }

    private void setDefaultJCacheManager(JCacheManager defaultJCacheManager) {
        this.defaultJCacheManager = defaultJCacheManager;
    }

    public InjectedCacheResolver() {
    }

    @Inject
    public InjectedCacheResolver(InfinispanExtension extension, BeanManager beanManager) {
        Set<InfinispanExtensionEmbedded.InstalledCacheManager> installedCacheManagers = extension.getEmbeddedExtension().getInstalledEmbeddedCacheManagers(beanManager);
        for (InfinispanExtensionEmbedded.InstalledCacheManager installedCacheManager : installedCacheManagers) {
            JCacheManager jcacheManager = this.toJCacheManager(installedCacheManager.getCacheManager());
            this.jcacheManagers.put(installedCacheManager.getCacheManager(), jcacheManager);
        }
        this.initializeDefaultCacheManagers();
    }

    private void initializeDefaultCacheManagers() {
        if (this.jcacheManagers.containsKey(this.getDefaultCacheManager())) {
            this.setDefaultJCacheManager(this.jcacheManagers.get(this.getDefaultCacheManager()));
        } else {
            this.setDefaultJCacheManager(this.toJCacheManager(this.getDefaultCacheManager()));
            this.jcacheManagers.put(this.getDefaultCacheManager(), this.getDefaultJCacheManager());
        }
    }

    private JCacheManager toJCacheManager(EmbeddedCacheManager cacheManager) {
        GlobalConfiguration globalCfg = cacheManager.getCacheManagerConfiguration();
        String name = globalCfg.globalJmxStatistics().cacheManagerName();
        return new JCacheManager(URI.create(name), cacheManager, Caching.getCachingProvider());
    }

    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cacheInvocationContext) {
        Contracts.assertNotNull(cacheInvocationContext, "cacheInvocationContext parameter must not be null");
        String cacheName = cacheInvocationContext.getCacheName();
        if (cacheName.trim().isEmpty()) {
            return this.getCacheFromDefaultCacheManager(cacheName);
        }
        for (EmbeddedCacheManager cm : this.jcacheManagers.keySet()) {
            Set<String> cacheNames = cm.getCacheNames();
            for (String name : cacheNames) {
                if (!name.equals(cacheName)) continue;
                JCacheManager jcacheManager = this.jcacheManagers.get(cm);
                Cache cache = jcacheManager.getCache(cacheName);
                if (cache != null) {
                    return cache;
                }
                return jcacheManager.getOrCreateCache(cacheName, cm.getCache(cacheName).getAdvancedCache());
            }
        }
        return this.getCacheFromDefaultCacheManager(cacheName);
    }

    private <K, V> Cache<K, V> getCacheFromDefaultCacheManager(String cacheName) {
        Configuration defaultInjectedConfiguration = this.getBeanReference(Configuration.class);
        this.getDefaultCacheManager().defineConfiguration(cacheName, defaultInjectedConfiguration);
        return this.getDefaultJCacheManager().getOrCreateCache(cacheName, this.getDefaultCacheManager().getCache(cacheName).getAdvancedCache());
    }

    private BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }

    private <T> T getBeanReference(Class<T> beanType) {
        BeanManager bm = this.getBeanManager();
        Iterator iterator = bm.getBeans(beanType, new Annotation[0]).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Default bean of type %s not found.", beanType.getName()));
        }
        Bean configurationBean = (Bean)iterator.next();
        CreationalContext createCreationalContext = bm.createCreationalContext((Contextual)configurationBean);
        return (T)bm.getReference(configurationBean, beanType, createCreationalContext);
    }
}

