/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTransactionalLockingInterceptor
extends AbstractLockingInterceptor {
    private static final Log log = LogFactory.getLog(NonTransactionalLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        return this.visitNonTxDataWriteCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        for (Object key : this.dataContainer.keySet()) {
            if (!this.shouldLock(key, command)) continue;
            this.lockKey(ctx, key, lockTimeout, skipLocking);
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            if (!command.isForwarded()) {
                boolean skipLocking = this.hasSkipLocking(command);
                long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
                for (Object key : command.getMap().keySet()) {
                    if (!this.shouldLock(key, command)) continue;
                    this.lockKey(ctx, key, lockTimeout, skipLocking);
                }
            }
            Object skipLocking = this.invokeNextInterceptor(ctx, command);
            return skipLocking;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    private void assertNonTransactional(InvocationContext ctx) {
        if (ctx.isInTxScope()) {
            throw new InvalidCacheUsageException("This is a non-transactional cache and cannot be accessed with a transactional InvocationContext.");
        }
    }
}

