/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LocalTransaction
extends AbstractCacheTransaction {
    private static final Log log = LogFactory.getLog(LocalTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private Set<Address> remoteLockedNodes;
    private Set<Object> readKeys = null;
    private final Transaction transaction;
    private final boolean implicitTransaction;
    private volatile boolean isFromRemoteSite;
    private boolean prepareSent;
    private boolean commitOrRollbackSent;

    public LocalTransaction(Transaction transaction, GlobalTransaction tx, boolean implicitTransaction, int topologyId, Equivalence<Object> keyEquivalence, long txCreationTime) {
        super(tx, topologyId, keyEquivalence, txCreationTime);
        this.transaction = transaction;
        this.implicitTransaction = implicitTransaction;
    }

    public final void addModification(WriteCommand mod) {
        if (trace) {
            log.tracef("Adding modification %s. Mod list is %s", (Object)mod, (Object)this.modifications);
        }
        if (this.modifications == null) {
            this.modifications = Collections.synchronizedList(new LinkedList());
        }
        if (mod.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            this.hasLocalOnlyModifications = true;
        }
        this.modifications.add(mod);
    }

    public void locksAcquired(Collection<Address> nodes) {
        if (trace) {
            log.tracef("Adding remote locks on %s. Remote locks are %s", (Object)nodes, (Object)this.remoteLockedNodes);
        }
        if (this.remoteLockedNodes == null) {
            this.remoteLockedNodes = new HashSet<Address>(nodes);
        } else {
            this.remoteLockedNodes.addAll(nodes);
        }
    }

    public Collection<Address> getRemoteLocksAcquired() {
        if (this.remoteLockedNodes == null) {
            return InfinispanCollections.emptySet();
        }
        return this.remoteLockedNodes;
    }

    public void clearRemoteLocksAcquired() {
        if (this.remoteLockedNodes != null) {
            this.remoteLockedNodes.clear();
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? InfinispanCollections.emptyMap() : this.lookedUpEntries;
    }

    public boolean isImplicitTransaction() {
        return this.implicitTransaction;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.isMarkedForRollback()) {
            throw new CacheException("This transaction is marked for rollback and cannot acquire locks!");
        }
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = CollectionFactory.makeMap(4, this.keyEquivalence, AnyEquivalence.getInstance());
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        if (this.isMarkedForRollback()) {
            throw new CacheException("This transaction is marked for rollback and cannot acquire locks!");
        }
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = CollectionFactory.makeMap(entries, this.keyEquivalence, AnyEquivalence.getInstance());
        } else {
            this.lookedUpEntries.putAll(entries);
        }
    }

    public boolean isReadOnly() {
        return this.modifications == null || this.modifications.isEmpty();
    }

    public abstract boolean isEnlisted();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransaction that = (LocalTransaction)o;
        return this.tx.getId() == that.tx.getId();
    }

    public int hashCode() {
        long id = this.tx.getId();
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        return "LocalTransaction{remoteLockedNodes=" + this.remoteLockedNodes + ", isMarkedForRollback=" + this.isMarkedForRollback() + ", lockedKeys=" + this.lockedKeys + ", backupKeyLocks=" + this.backupKeyLocks + ", topologyId=" + this.topologyId + ", stateTransferFlag=" + (Object)((Object)this.getStateTransferFlag()) + "} " + super.toString();
    }

    @Override
    public void addReadKey(Object key) {
        if (this.readKeys == null) {
            this.readKeys = new HashSet<Object>(2);
        }
        this.readKeys.add(key);
    }

    @Override
    public boolean keyRead(Object key) {
        return this.readKeys != null && this.readKeys.contains(key);
    }

    @Override
    public void setStateTransferFlag(Flag stateTransferFlag) {
        if (this.getStateTransferFlag() == null && (stateTransferFlag == Flag.PUT_FOR_STATE_TRANSFER || stateTransferFlag == Flag.PUT_FOR_X_SITE_STATE_TRANSFER)) {
            this.internalSetStateTransferFlag(stateTransferFlag);
        }
    }

    public boolean isFromRemoteSite() {
        return this.isFromRemoteSite;
    }

    public void setFromRemoteSite(boolean fromRemoteSite) {
        this.isFromRemoteSite = fromRemoteSite;
    }

    public Collection<Address> getCommitNodes(Collection<Address> recipients, int currentTopologyId, Collection<Address> members) {
        if (trace) {
            log.tracef("getCommitNodes recipients=%s, currentTopologyId=%s, members=%s, txTopologyId=%s", recipients, currentTopologyId, members, this.getTopologyId());
        }
        if (this.hasModification(ClearCommand.class)) {
            return members;
        }
        if (recipients == null) {
            return null;
        }
        if (this.getTopologyId() == currentTopologyId) {
            return recipients;
        }
        HashSet<Address> allRecipients = new HashSet<Address>(this.getRemoteLocksAcquired());
        allRecipients.addAll(recipients);
        allRecipients.retainAll(members);
        if (trace) {
            log.tracef("The merged list of nodes to send commit/rollback is %s", (Object)allRecipients);
        }
        return allRecipients;
    }

    public final void markPrepareSent() {
        this.prepareSent = true;
    }

    public final boolean isPrepareSent() {
        return this.prepareSent;
    }

    public final void markCommitOrRollbackSent() {
        this.commitOrRollbackSent = true;
    }

    public final boolean isCommitOrRollbackSent() {
        return this.commitOrRollbackSent;
    }
}

