/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.marshalling.AbstractMarshaller;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.serial.BlockMarshaller;
import org.jboss.marshalling.serial.ExtendedObjectStreamConstants;
import org.jboss.marshalling.serial.ExternalizedObject;
import org.jboss.marshalling.serial.SerialObjectOutputStream;
import org.jboss.marshalling.util.FieldPutter;
import org.jboss.marshalling.util.IdentityIntMap;
import org.jboss.marshalling.util.Kind;

public final class SerialMarshaller
extends AbstractMarshaller
implements Marshaller,
ExtendedObjectStreamConstants {
    private static final int MIN_BUFFER_SIZE = 16;
    private final SerializableClassRegistry registry;
    private final IdentityIntMap<Object> instanceCache;
    private final IdentityIntMap<Class<?>> descriptorCache;
    private final IdentityHashMap<Object, Object> replacementCache;
    private final IdentityHashMap<Class<?>, Externalizer> externalizers;
    private final int bufferSize;
    private SerialObjectOutputStream oos;
    private BlockMarshaller blockMarshaller;
    private int instanceSeq;
    private final PrivilegedExceptionAction<SerialObjectOutputStream> createObjectOutputStreamAction = new PrivilegedExceptionAction<SerialObjectOutputStream>(){

        @Override
        public SerialObjectOutputStream run() throws IOException {
            return new SerialObjectOutputStream(SerialMarshaller.this, SerialMarshaller.this.blockMarshaller);
        }
    };
    private static final IdentityIntMap<Class<?>> primitives = new IdentityIntMap(32);

    SerialMarshaller(AbstractMarshallerFactory marshallerFactory, SerializableClassRegistry registry, MarshallingConfiguration configuration) throws IOException {
        super(marshallerFactory, configuration);
        if (this.configuredVersion != 5) {
            throw new IOException("Only protocol version 5 is supported for writing");
        }
        this.registry = registry;
        this.instanceCache = new IdentityIntMap(configuration.getInstanceCount());
        this.descriptorCache = new IdentityIntMap(configuration.getClassCount());
        this.replacementCache = new IdentityHashMap(configuration.getInstanceCount());
        this.externalizers = new IdentityHashMap(configuration.getClassCount());
        this.bufferSize = configuration.getBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteObject(Object orig, boolean unshared) throws IOException {
        Externalizer externalizer;
        Class<?> objClass;
        SerializableClass sc;
        int v;
        if (orig == null) {
            this.write(112);
            return;
        }
        IdentityHashMap<Object, Object> replacementCache = this.replacementCache;
        Object obj = replacementCache.containsKey(orig) ? replacementCache.get(orig) : orig;
        IdentityIntMap<Object> instanceCache = this.instanceCache;
        obj = this.objectPreResolver.writeReplace(obj);
        if (!unshared && (v = instanceCache.get(obj, -1)) != -1) {
            this.write(113);
            this.writeInt(v + 0x7E0000);
            return;
        }
        ObjectTable.Writer writer = this.objectTable.getObjectWriter(obj);
        if (writer != null) {
            this.write(241);
            int id = this.instanceSeq++;
            if (!unshared) {
                instanceCache.put(obj, id);
            }
            writer.writeObject(this.blockMarshaller, obj);
            this.doEndBlock();
            return;
        }
        if (obj instanceof Class) {
            this.write(118);
            this.writeNewClassDescFor((Class)obj);
            int id = this.instanceSeq++;
            if (!unshared) {
                instanceCache.put(obj, id);
            }
            return;
        }
        if (obj instanceof ObjectStreamClass) {
            throw new NotSerializableException(ObjectStreamClass.class.getName());
        }
        SerializableClassRegistry registry = this.registry;
        while ((sc = registry.lookup(objClass = obj.getClass())).hasWriteReplace()) {
            Object replacement = sc.callWriteReplace(obj);
            try {
                if (replacement != null && replacement != obj && obj.getClass() != objClass) continue;
                break;
            }
            finally {
                obj = replacement;
            }
        }
        obj = this.objectResolver.writeReplace(obj);
        if (obj != orig) {
            replacementCache.put(orig, obj);
            if (obj == null) {
                this.write(112);
                return;
            }
            if (!unshared && (v = instanceCache.get(obj, -1)) != -1) {
                this.write(113);
                this.writeInt(v);
                return;
            }
            if (obj instanceof Class) {
                this.write(118);
                this.writeNewClassDescFor((Class)obj);
                int id = this.instanceSeq++;
                if (!unshared) {
                    instanceCache.put(obj, id);
                }
                return;
            }
            if (obj instanceof ObjectStreamClass) {
                throw new NotSerializableException(ObjectStreamClass.class.getName());
            }
        }
        if (obj instanceof String) {
            String string = (String)obj;
            long len = UTFUtils.getLongUTFLength(string);
            if (len < 65536L) {
                this.write(116);
                int id = this.instanceSeq++;
                if (!unshared) {
                    instanceCache.put(obj, id);
                }
                this.writeShort((int)len);
                UTFUtils.writeUTFBytes(this, string);
                return;
            }
            this.write(124);
            int id = this.instanceSeq++;
            if (!unshared) {
                instanceCache.put(obj, id);
            }
            this.writeLong(len);
            UTFUtils.writeUTFBytes(this, string);
            return;
        }
        objClass = obj.getClass();
        if (obj instanceof Enum) {
            this.write(126);
            Enum theEnum = (Enum)obj;
            this.writeClassDescFor(theEnum.getDeclaringClass());
            int id = this.instanceSeq++;
            if (!unshared) {
                instanceCache.put(obj, id);
            }
            this.doWriteObject(theEnum.name(), false);
            return;
        }
        if (objClass.isArray()) {
            this.write(117);
            this.writeClassDescFor(objClass);
            int id = this.instanceSeq++;
            if (!unshared) {
                instanceCache.put(obj, id);
            }
            if (obj instanceof byte[]) {
                byte[] bytes = (byte[])obj;
                this.writeInt(bytes.length);
                this.write(bytes);
            } else if (obj instanceof short[]) {
                short[] shorts = (short[])obj;
                this.writeInt(shorts.length);
                for (short s : shorts) {
                    this.writeShort(s);
                }
            } else if (obj instanceof int[]) {
                int[] ints = (int[])obj;
                this.writeInt(ints.length);
                for (int s : ints) {
                    this.writeInt(s);
                }
            } else if (obj instanceof long[]) {
                long[] longs = (long[])obj;
                this.writeInt(longs.length);
                for (long s : longs) {
                    this.writeLong(s);
                }
            } else if (obj instanceof float[]) {
                float[] floats = (float[])obj;
                this.writeInt(floats.length);
                for (float s : floats) {
                    this.writeFloat(s);
                }
            } else if (obj instanceof double[]) {
                double[] doubles = (double[])obj;
                this.writeInt(doubles.length);
                for (double s : doubles) {
                    this.writeDouble(s);
                }
            } else if (obj instanceof boolean[]) {
                boolean[] booleans = (boolean[])obj;
                this.writeInt(booleans.length);
                for (boolean s : booleans) {
                    this.writeBoolean(s);
                }
            } else if (obj instanceof char[]) {
                char[] chars = (char[])obj;
                this.writeInt(chars.length);
                for (char s : chars) {
                    this.writeChar(s);
                }
            } else {
                Object[] objs = (Object[])obj;
                this.writeInt(objs.length);
                for (Object o : objs) {
                    this.doWriteObject(o, false);
                }
            }
            return;
        }
        if (this.externalizers.containsKey(objClass)) {
            externalizer = this.externalizers.get(objClass);
        } else {
            externalizer = this.classExternalizerFactory.getExternalizer(objClass);
            this.externalizers.put(objClass, externalizer);
        }
        if (externalizer != null) {
            ExternalizedObject eo = new ExternalizedObject(externalizer, obj);
            this.doWriteObject(eo, unshared);
            replacementCache.put(obj, eo);
            return;
        }
        if (obj instanceof Externalizable) {
            this.write(115);
            this.writeClassDescFor(objClass);
            int id = this.instanceSeq++;
            if (!unshared) {
                instanceCache.put(obj, id);
            }
            Externalizable externalizable = (Externalizable)obj;
            externalizable.writeExternal(this.blockMarshaller);
            this.doEndBlock();
            return;
        }
        if (this.serializabilityChecker.isSerializable(objClass)) {
            this.write(115);
            this.writeClassDescFor(objClass);
            int id = this.instanceSeq++;
            if (!unshared) {
                instanceCache.put(obj, id);
            }
            this.writeSerialData(objClass, obj);
            return;
        }
        throw new NotSerializableException(objClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSerialData(Class<?> objClass, Object obj) throws IOException {
        SerializableClass sc;
        Class<?> superClass = objClass.getSuperclass();
        if (superClass != null && this.serializabilityChecker.isSerializable(superClass)) {
            this.writeSerialData(superClass, obj);
        }
        if ((sc = this.registry.lookup(objClass)).hasWriteObject()) {
            SerialObjectOutputStream oos = this.getObjectOutputStream();
            Object oldObj = oos.saveCurrentObject(obj);
            SerializableClass oldSc = oos.saveCurrentSerializableClass(sc);
            Map<String, FieldPutter> map = oos.saveCurrentFieldMap();
            SerialObjectOutputStream.State oldState = oos.saveState();
            try {
                sc.callWriteObject(obj, oos);
            }
            finally {
                oos.setCurrentObject(oldObj);
                oos.setCurrentSerializableClass(oldSc);
                oos.setCurrentFieldMap(map);
                oos.restoreState(oldState);
            }
            this.doEndBlock();
        } else {
            this.doWriteFields(sc, obj);
        }
    }

    private SerialObjectOutputStream createObjectOutputStream() throws IOException {
        try {
            return AccessController.doPrivileged(this.createObjectOutputStreamAction);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private SerialObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.oos == null) {
            this.oos = this.createObjectOutputStream();
        }
        return this.oos;
    }

    protected void doWriteFields(SerializableClass info, Object obj) throws IOException {
        Field field;
        SerializableField[] serializableFields;
        for (SerializableField serializableField : serializableFields = info.getFields()) {
            try {
                field = serializableField.getField();
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        this.writeBoolean(field == null ? false : field.getBoolean(obj));
                        break;
                    }
                    case BYTE: {
                        this.writeByte(field == null ? 0 : (int)field.getByte(obj));
                        break;
                    }
                    case SHORT: {
                        this.writeShort(field == null ? 0 : (int)field.getShort(obj));
                        break;
                    }
                    case INT: {
                        this.writeInt(field == null ? 0 : field.getInt(obj));
                        break;
                    }
                    case CHAR: {
                        this.writeChar(field == null ? 0 : (int)field.getChar(obj));
                        break;
                    }
                    case LONG: {
                        this.writeLong(field == null ? 0L : field.getLong(obj));
                        break;
                    }
                    case DOUBLE: {
                        this.writeDouble(field == null ? 0.0 : field.getDouble(obj));
                        break;
                    }
                    case FLOAT: {
                        this.writeFloat(field == null ? 0.0f : field.getFloat(obj));
                    }
                }
            }
            catch (IllegalAccessException e) {
                InvalidObjectException ioe = new InvalidObjectException("Unexpected illegal access exception");
                ioe.initCause(e);
                throw ioe;
            }
        }
        for (SerializableField serializableField : serializableFields) {
            try {
                field = serializableField.getField();
                Kind i = serializableField.getKind();
                if (i != Kind.OBJECT) continue;
                this.doWriteObject(field == null ? null : field.get(obj), serializableField.isUnshared());
            }
            catch (IllegalAccessException e) {
                InvalidObjectException ioe = new InvalidObjectException("Unexpected illegal access exception");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private void writeClassDescFor(Class<?> forClass) throws IOException {
        if (forClass == null) {
            this.write(112);
        } else {
            int id = this.descriptorCache.get(forClass, -1);
            if (id == -1) {
                this.writeNewClassDescFor(forClass);
            } else {
                this.write(113);
                this.writeInt(id + 0x7E0000);
            }
        }
    }

    private void writeNewClassDescFor(Class<?> forClass) throws IOException {
        if (Proxy.isProxyClass(forClass)) {
            this.writeNewProxyClassDesc(forClass);
        } else {
            this.writeNewPlainClassDesc(forClass);
        }
    }

    private void writeNewProxyClassDesc(Class<?> forClass) throws IOException {
        this.write(125);
        this.descriptorCache.put(forClass, this.instanceSeq++);
        String[] names = this.classResolver.getProxyInterfaces(forClass);
        this.writeInt(names.length);
        for (String name : names) {
            this.writeUTF(name);
        }
        this.classResolver.annotateProxyClass(this.blockMarshaller, forClass);
        this.doEndBlock();
        this.writeClassDescFor(forClass.getSuperclass());
    }

    private void writeNewPlainClassDesc(Class<?> forClass) throws IOException {
        Object sc;
        ClassTable.Writer writer = this.classTable.getClassWriter(forClass);
        if (writer != null) {
            this.write(240);
            this.descriptorCache.put(forClass, this.instanceSeq++);
            writer.writeClass(this.blockMarshaller, forClass);
            this.doEndBlock();
            return;
        }
        this.write(114);
        this.writeUTF(this.classResolver.getClassName(forClass));
        this.descriptorCache.put(forClass, this.instanceSeq++);
        if (forClass.isEnum()) {
            this.writeLong(0L);
            this.write(18);
            this.writeShort(0);
        } else if (this.serializabilityChecker.isSerializable(forClass)) {
            sc = this.registry.lookup(forClass);
            long svu = ((SerializableClass)sc).getEffectiveSerialVersionUID();
            this.writeLong(svu);
            if (Externalizable.class.isAssignableFrom(forClass)) {
                this.write(12);
                this.writeShort(0);
            } else {
                Class<?> type;
                String name;
                Kind kind;
                if (((SerializableClass)sc).hasWriteObject()) {
                    this.write(3);
                } else {
                    this.write(2);
                }
                SerializableField[] fields = ((SerializableClass)sc).getFields();
                this.writeShort(fields.length);
                for (SerializableField field : fields) {
                    kind = field.getKind();
                    name = field.getName();
                    try {
                        type = field.getType();
                    }
                    catch (ClassNotFoundException e) {
                        throw new InvalidClassException(forClass.getName(), "Field " + name + "'s class was not found");
                    }
                    if (kind == Kind.OBJECT) continue;
                    this.write(primitives.get(type, -1));
                    this.writeUTF(name);
                }
                for (SerializableField field : fields) {
                    kind = field.getKind();
                    name = field.getName();
                    try {
                        type = field.getType();
                    }
                    catch (ClassNotFoundException e) {
                        throw new InvalidClassException(forClass.getName(), "Field " + name + "'s class was not found");
                    }
                    if (kind != Kind.OBJECT) continue;
                    String signature = SerialMarshaller.getSignature(type).intern();
                    this.write(signature.charAt(0));
                    this.writeUTF(name);
                    this.writeObject(signature);
                }
            }
        } else {
            this.writeLong(0L);
            this.write(0);
            this.writeShort(0);
        }
        this.classResolver.annotateClass(this.blockMarshaller, forClass);
        this.doEndBlock();
        sc = forClass.getSuperclass();
        if (sc != null && this.serializabilityChecker.isSerializable((Class<?>)sc) && !forClass.isEnum()) {
            this.writeClassDescFor((Class<?>)sc);
        } else {
            this.write(112);
        }
    }

    private void doEndBlock() throws IOException {
        this.blockMarshaller.flush();
        this.write(120);
    }

    private static String getSignature(Class<?> type) {
        int id = primitives.get(type, -1);
        if (id != -1) {
            return Character.toString((char)id);
        }
        if (type.isArray()) {
            return "[" + SerialMarshaller.getSignature(type.getComponentType());
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    @Override
    public void clearInstanceCache() throws IOException {
        this.instanceCache.clear();
        this.descriptorCache.clear();
        this.replacementCache.clear();
        this.externalizers.clear();
        this.instanceSeq = 0;
        if (this.byteOutput != null) {
            this.write(121);
        }
    }

    @Override
    public void clearClassCache() throws IOException {
        this.clearInstanceCache();
    }

    @Override
    public void start(ByteOutput byteOutput) throws IOException {
        this.blockMarshaller = new BlockMarshaller(this, this.bufferSize < 16 ? 16 : this.bufferSize);
        super.start(byteOutput);
        this.writeShort(this.configuredVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws IOException {
        try {
            super.finish();
        }
        finally {
            this.blockMarshaller = null;
            this.oos = null;
        }
    }

    @Override
    public void flush() throws IOException {
        BlockMarshaller blockMarshaller = this.blockMarshaller;
        if (blockMarshaller != null) {
            blockMarshaller.flush();
        }
        super.flush();
    }

    void writeNoBlockFlush(byte[] bytes, int off, int len) throws IOException {
        super.flush();
        this.byteOutput.write(bytes, off, len);
    }

    static {
        primitives.put(Byte.TYPE, 66);
        primitives.put(Character.TYPE, 67);
        primitives.put(Double.TYPE, 68);
        primitives.put(Float.TYPE, 70);
        primitives.put(Integer.TYPE, 73);
        primitives.put(Long.TYPE, 74);
        primitives.put(Short.TYPE, 83);
        primitives.put(Boolean.TYPE, 90);
        primitives.put(Void.TYPE, 86);
    }
}

