/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class MortalCacheEntry
extends AbstractInternalCacheEntry {
    protected Object value;
    protected long lifespan = -1L;
    protected long created;

    public MortalCacheEntry(Object key, Object value, long lifespan, long created) {
        super(key);
        this.value = value;
        this.lifespan = lifespan;
        this.created = created;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        this.value = value;
        return this.value;
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredMortal(this.lifespan, this.created, now);
    }

    @Override
    public final boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    public void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    @Override
    public final long getCreated() {
        return this.created;
    }

    @Override
    public final long getLastUsed() {
        return -1L;
    }

    @Override
    public final long getLifespan() {
        return this.lifespan;
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public final long getExpiryTime() {
        return this.lifespan > -1L ? this.created + this.lifespan : -1L;
    }

    @Override
    public final void touch() {
    }

    @Override
    public final void touch(long currentTimeMillis) {
    }

    @Override
    public final void reincarnate() {
        this.reincarnate(System.currentTimeMillis());
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    public InternalCacheValue toInternalCacheValue() {
        return new MortalCacheValue(this.value, this.created, this.lifespan);
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().lifespan(this.lifespan).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MortalCacheEntry that = (MortalCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.created != that.created) {
            return false;
        }
        return this.lifespan == that.lifespan;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
        return result;
    }

    @Override
    public MortalCacheEntry clone() {
        return (MortalCacheEntry)super.clone();
    }

    @Override
    public String toString() {
        return "MortalCacheEntry{key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<MortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MortalCacheEntry mce) throws IOException {
            output.writeObject(mce.key);
            output.writeObject(mce.value);
            UnsignedNumeric.writeUnsignedLong(output, mce.created);
            output.writeLong(mce.lifespan);
        }

        @Override
        public MortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            return new MortalCacheEntry(k, v, lifespan, created);
        }

        @Override
        public Integer getId() {
            return 11;
        }

        @Override
        public Set<Class<? extends MortalCacheEntry>> getTypeClasses() {
            return Util.asSet(MortalCacheEntry.class);
        }
    }
}

