/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.configuration;

import java.util.Properties;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.leveldb.LevelDBStore;
import org.infinispan.persistence.leveldb.configuration.CompressionType;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;

@ConfigurationFor(value=LevelDBStore.class)
@BuiltBy(value=LevelDBStoreConfigurationBuilder.class)
public class LevelDBStoreConfiguration
extends AbstractStoreConfiguration {
    private final String location;
    private final String expiredLocation;
    private final ImplementationType implementationType;
    private final CompressionType compressionType;
    private final Integer blockSize;
    private final Long cacheSize;
    private final int expiryQueueSize;
    private final int clearThreshold;

    public LevelDBStoreConfiguration(boolean purgeOnStartup, boolean fetchPersistentState, boolean ignoreModifications, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, boolean preload, boolean shared, Properties properties, String location, String expiredLocation, ImplementationType implementationType, CompressionType compressionType, Integer blockSize, Long cacheSize, int expiryQueueSize, int clearThreshold) {
        super(purgeOnStartup, fetchPersistentState, ignoreModifications, async, singletonStore, preload, shared, properties);
        this.location = location;
        this.expiredLocation = expiredLocation;
        this.implementationType = implementationType;
        this.compressionType = compressionType;
        this.blockSize = blockSize;
        this.cacheSize = cacheSize;
        this.expiryQueueSize = expiryQueueSize;
        this.clearThreshold = clearThreshold;
    }

    public String location() {
        return this.location;
    }

    public String expiredLocation() {
        return this.expiredLocation;
    }

    public ImplementationType implementationType() {
        return this.implementationType;
    }

    public CompressionType compressionType() {
        return this.compressionType;
    }

    public Integer blockSize() {
        return this.blockSize;
    }

    public Long cacheSize() {
        return this.cacheSize;
    }

    public int expiryQueueSize() {
        return this.expiryQueueSize;
    }

    public int clearThreshold() {
        return this.clearThreshold;
    }

    public static enum ImplementationType {
        AUTO,
        JAVA,
        JNI;

    }
}

