/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.impl;

import org.infinispan.commons.util.concurrent.jdk8backported.LongAdder;

public class Stats {
    private final Operation entityFind = new Operation();
    private final Operation entityMerge = new Operation();
    private final Operation entityRemove = new Operation();
    private final Operation metadataFind = new Operation();
    private final Operation metadataMerge = new Operation();
    private final Operation metadataRemove = new Operation();
    private final Operation txReadCommitted = new Operation();
    private final Operation txWriteCommitted = new Operation();
    private final Operation txRemoveCommitted = new Operation();
    private final Operation txReadFailed = new Operation();
    private final Operation txWriteFailed = new Operation();
    private final Operation txRemoveFailed = new Operation();

    public void addEntityMerge(long duration) {
        this.entityMerge.add(duration);
    }

    public void addMetadataMerge(long duration) {
        this.metadataMerge.add(duration);
    }

    public void addWriteTxCommited(long duration) {
        this.txWriteCommitted.add(duration);
    }

    public void addWriteTxFailed(long duration) {
        this.txWriteFailed.add(duration);
    }

    public void addEntityFind(long duration) {
        this.entityFind.add(duration);
    }

    public void addMetadataFind(long duration) {
        this.metadataFind.add(duration);
    }

    public void addReadTxCommitted(long duration) {
        this.txReadCommitted.add(duration);
    }

    public void addReadTxFailed(long duration) {
        this.txReadFailed.add(duration);
    }

    public void addEntityRemove(long duration) {
        this.entityRemove.add(duration);
    }

    public void addMetadataRemove(long duration) {
        this.metadataRemove.add(duration);
    }

    public void addRemoveTxCommitted(long duration) {
        this.txRemoveCommitted.add(duration);
    }

    public void addRemoveTxFailed(long duration) {
        this.txRemoveFailed.add(duration);
    }

    public String toString() {
        return "Stats{\nentityFind=" + this.entityFind + "\nentityMerge=" + this.entityMerge + "\nentityRemove=" + this.entityRemove + "\nmetadataFind=" + this.metadataFind + "\nmetadataMerge=" + this.metadataMerge + "\nmetadataRemove=" + this.metadataRemove + "\ntxReadCommitted=" + this.txReadCommitted + "\ntxReadFailed=" + this.txReadFailed + "\ntxWriteCommitted=" + this.txWriteCommitted + "\ntxWriteFailed=" + this.txWriteFailed + "\ntxRemoveCommitted=" + this.txRemoveCommitted + "\ntxRemoveFailed=" + this.txRemoveFailed + '}';
    }

    private class Operation {
        final LongAdder count = new LongAdder();
        final LongAdder sum = new LongAdder();

        private Operation() {
        }

        void add(long duration) {
            this.count.increment();
            this.sum.add(duration);
        }

        public String toString() {
            long count = this.count.sum();
            long sum = this.sum.sum();
            return String.format("[count=%d, avg=%.2f ms]", count, count == 0L ? Double.NaN : (double)sum / (1000000.0 * (double)count));
        }
    }
}

