/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.infinispan.jcache.JCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JCachingProvider
implements CachingProvider {
    private static final Log log = LogFactory.getLog(JCachingProvider.class);
    private static final URI DEFAULT_URI = URI.create(JCachingProvider.class.getName());
    private final Map<ClassLoader, Map<URI, JCacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, JCacheManager>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI globalUri = uri == null ? this.getDefaultURI() : uri;
        ClassLoader globalClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        Properties globalProperties = properties == null ? new Properties() : properties;
        Map<ClassLoader, Map<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            JCacheManager cacheManager;
            Map<URI, JCacheManager> map2 = this.cacheManagers.get(globalClassLoader);
            if (map2 == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("No cache managers registered under '%s'", (Object)globalUri);
                }
                map2 = new HashMap<URI, JCacheManager>();
                this.cacheManagers.put(globalClassLoader, map2);
            }
            if ((cacheManager = map2.get(globalUri)) == null || cacheManager.isClosed()) {
                cacheManager = this.createCacheManager(globalClassLoader, globalUri, globalProperties);
                if (log.isTraceEnabled()) {
                    log.tracef("Created '%s' cache manager", (Object)globalUri);
                }
                map2.put(globalUri, cacheManager);
            }
            return cacheManager;
        }
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        return DEFAULT_URI;
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(DEFAULT_URI, this.getDefaultClassLoader());
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, Map<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (Map<URI, JCacheManager> map2 : this.cacheManagers.values()) {
                this.close(map2);
            }
            this.cacheManagers.clear();
            if (log.isTraceEnabled()) {
                log.tracef("All cache managers have been removed", new Object[0]);
            }
        }
    }

    public void close(ClassLoader classLoader) {
        this.close(null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            if (uri != null) {
                Map<URI, JCacheManager> map2 = this.cacheManagers.get(classLoader);
                if (map2 != null) {
                    JCacheManager cacheManager = map2.remove(uri);
                    if (map2.isEmpty()) {
                        this.cacheManagers.remove(classLoader);
                    }
                    if (cacheManager != null) {
                        cacheManager.close();
                    }
                }
            } else {
                Map<URI, JCacheManager> cacheManagersToClose = this.cacheManagers.remove(classLoader);
                if (cacheManagersToClose != null) {
                    this.close(cacheManagersToClose);
                }
            }
        }
    }

    private void close(Map<URI, JCacheManager> map) {
        for (CacheManager cacheManager : map.values()) {
            cacheManager.close();
            if (!log.isTraceEnabled()) continue;
            log.tracef("Shutdown cache manager '%s'", (Object)cacheManager.getURI());
        }
    }

    private JCacheManager createCacheManager(ClassLoader classLoader, URI uri, Properties properties) {
        return new JCacheManager(uri, classLoader, this, properties);
    }
}

