/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.NoSuchElementException;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.CacheEntry;

public class RemovableEntryIterator<K, C>
implements CloseableIterator<CacheEntry<K, C>> {
    protected final CloseableIterator<CacheEntry<K, C>> realIterator;
    protected final Cache<K, ?> cache;
    protected CacheEntry<K, C> previousValue;
    protected CacheEntry<K, C> currentValue;

    public RemovableEntryIterator(CloseableIterator<CacheEntry<K, C>> realIterator, Cache<K, ?> cache, boolean initIterator) {
        this.realIterator = realIterator;
        this.cache = cache;
        if (initIterator) {
            this.currentValue = this.getNextFromIterator();
        }
    }

    protected CacheEntry<K, C> getNextFromIterator() {
        if (this.realIterator.hasNext()) {
            return (CacheEntry)this.realIterator.next();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue != null;
    }

    @Override
    public CacheEntry<K, C> next() {
        if (this.currentValue == null) {
            throw new NoSuchElementException();
        }
        this.previousValue = this.currentValue;
        this.currentValue = this.getNextFromIterator();
        return this.previousValue;
    }

    @Override
    public void remove() {
        if (this.previousValue == null) {
            throw new IllegalStateException();
        }
        this.cache.remove(this.previousValue.getKey());
        this.previousValue = null;
    }

    @Override
    public void close() {
        this.currentValue = null;
        this.previousValue = null;
        this.realIterator.close();
    }
}

