/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.ref.WeakReference;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.BootstrapFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentRegistry
extends AbstractComponentRegistry {
    private final GlobalComponentRegistry globalComponents;
    private final String cacheName;
    private static final Log log = LogFactory.getLog(ComponentRegistry.class);
    private CacheManagerNotifier cacheManagerNotifier;
    private StreamingMarshaller cacheMarshaler;
    private StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private CommandsFactory commandsFactory;
    private TotalOrderManager totalOrderManager;
    private StateTransferLock stateTransferLock;
    protected final WeakReference<ClassLoader> defaultClassLoader;

    @Inject
    public void setCacheManagerNotifier(CacheManagerNotifier cacheManagerNotifier) {
        this.cacheManagerNotifier = cacheManagerNotifier;
    }

    public ComponentRegistry(String cacheName, Configuration configuration, AdvancedCache<?, ?> cache, GlobalComponentRegistry globalComponents, ClassLoader defaultClassLoader) {
        this.defaultClassLoader = new WeakReference<ClassLoader>(defaultClassLoader);
        try {
            this.cacheName = cacheName;
            if (cacheName == null) {
                throw new CacheConfigurationException("Cache name cannot be null!");
            }
            if (globalComponents == null) {
                throw new NullPointerException("GlobalComponentRegistry cannot be null!");
            }
            this.globalComponents = globalComponents;
            this.registerComponent((Object)this, ComponentRegistry.class);
            this.registerComponent((Object)configuration, Configuration.class);
            this.registerComponent((Object)new BootstrapFactory(cache, configuration, this), BootstrapFactory.class);
            Map<Byte, ModuleCommandInitializer> initializers = globalComponents.getModuleCommandInitializers();
            if (initializers != null && !initializers.isEmpty()) {
                this.registerNonVolatileComponent(initializers, "org.infinispan.modules.command.initializers");
                for (ModuleCommandInitializer mci : initializers.values()) {
                    this.registerNonVolatileComponent((Object)mci, mci.getClass());
                }
            } else {
                this.registerNonVolatileComponent(InfinispanCollections.emptyMap(), "org.infinispan.modules.command.initializers");
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a ComponentRegistry!", e);
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return (ClassLoader)this.defaultClassLoader.get();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public final <T> T getComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        if (this.isGlobal(componentTypeName, name, nameIsFQCN)) {
            return this.globalComponents.getComponent(componentTypeName, name, nameIsFQCN);
        }
        return this.getLocalComponent(componentTypeName, name, nameIsFQCN);
    }

    public final <T> T getLocalComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        return super.getComponent(componentTypeName, name, nameIsFQCN);
    }

    public final <T> T getLocalComponent(Class<T> componentType) {
        String componentTypeName = componentType.getName();
        return this.getLocalComponent(componentTypeName, componentTypeName, true);
    }

    @Override
    protected final AbstractComponentRegistry.Component lookupComponent(String componentClassName, String name, boolean nameIsFQCN) {
        if (this.isGlobal(componentClassName, name, nameIsFQCN)) {
            log.tracef("Looking up global component %s", (Object)componentClassName);
            return this.globalComponents.lookupComponent(componentClassName, name, nameIsFQCN);
        }
        log.tracef("Looking up local component %s", (Object)componentClassName);
        return this.lookupLocalComponent(componentClassName, name, nameIsFQCN);
    }

    protected final AbstractComponentRegistry.Component lookupLocalComponent(String componentClassName, String name, boolean nameIsFQCN) {
        return super.lookupComponent(componentClassName, name, nameIsFQCN);
    }

    public final GlobalComponentRegistry getGlobalComponentRegistry() {
        return this.globalComponents;
    }

    @Override
    protected final <T> T getOrCreateComponent(Class<T> componentClass, String name, boolean nameIsFQCN) {
        if (this.isGlobal(componentClass.getName(), name, nameIsFQCN)) {
            log.tracef("Get or create global component %s", (Object)componentClass);
            return this.globalComponents.getOrCreateComponent(componentClass, name, nameIsFQCN);
        }
        log.tracef("Get or create local component %s", (Object)componentClass);
        return super.getOrCreateComponent(componentClass, name, nameIsFQCN);
    }

    private <T> boolean isGlobal(String componentClassName, String name, boolean nameIsFQCN) {
        if (!nameIsFQCN) {
            for (String s : KnownComponentNames.PER_CACHE_COMPONENT_NAMES) {
                if (!s.equals(name)) continue;
                return false;
            }
        }
        return this.isGlobal(nameIsFQCN ? name : componentClassName);
    }

    @Override
    protected AbstractComponentFactory getFactory(Class<?> componentClass) {
        AbstractComponentFactory cf;
        String cfClass = this.getComponentMetadataRepo().findFactoryForComponent(componentClass);
        if (cfClass == null) {
            this.throwStackAwareConfigurationException("No registered default factory for component '" + componentClass + "' found!");
        }
        if (this.isGlobal(cfClass)) {
            log.tracef("Looking up global factory for component %s", (Object)componentClass);
            cf = this.globalComponents.getFactory(componentClass);
        } else {
            log.tracef("Looking up local factory for component %s", (Object)componentClass);
            cf = super.getFactory(componentClass);
        }
        return cf;
    }

    @Override
    protected final void registerComponentInternal(Object component, String name, boolean nameIsFQCN) {
        if (this.isGlobal(component.getClass().getName(), name, nameIsFQCN)) {
            this.globalComponents.registerComponentInternal(component, name, nameIsFQCN);
        } else {
            super.registerComponentInternal(component, name, nameIsFQCN);
        }
    }

    @Override
    protected AbstractComponentFactory createComponentFactoryInternal(Class<?> componentClass, String cfClass) {
        if (this.isGlobal(cfClass)) {
            return this.globalComponents.createComponentFactoryInternal(componentClass, cfClass);
        }
        return super.createComponentFactoryInternal(componentClass, cfClass);
    }

    private boolean isGlobal(String className) {
        ComponentMetadata m = this.getComponentMetadataRepo().findComponentMetadata(className);
        return m != null && m.isGlobalScope();
    }

    @Override
    public void start() {
        this.globalComponents.start();
        boolean needToNotify = this.state != ComponentStatus.RUNNING && this.state != ComponentStatus.INITIALIZING;
        this.cacheComponents();
        this.globalComponents.registerNamedComponentRegistry(this, this.cacheName);
        this.notifyCacheStarting(this.getComponent(Configuration.class));
        super.start();
        if (needToNotify && this.state == ComponentStatus.RUNNING) {
            for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
                l.cacheStarted(this, this.cacheName);
            }
            this.cacheManagerNotifier.notifyCacheStarted(this.cacheName);
        }
    }

    void notifyCacheStarting(Configuration configuration) {
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            l.cacheStarting(this, configuration, this.cacheName);
        }
    }

    @Override
    public void stop() {
        boolean needToNotify;
        if (this.state.stopAllowed()) {
            this.globalComponents.unregisterNamedComponentRegistry(this.cacheName);
        }
        boolean bl = needToNotify = this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING;
        if (needToNotify) {
            for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
                l.cacheStopping(this, this.cacheName);
            }
        }
        super.stop();
        if (this.state == ComponentStatus.TERMINATED && needToNotify) {
            for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
                l.cacheStopped(this, this.cacheName);
            }
            this.cacheManagerNotifier.notifyCacheStopped(this.cacheName);
        }
    }

    @Override
    public TimeService getTimeService() {
        return this.globalComponents.getTimeService();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public StreamingMarshaller getCacheMarshaller() {
        return this.cacheMarshaler;
    }

    public StateTransferManager getStateTransferManager() {
        return this.stateTransferManager;
    }

    public ResponseGenerator getResponseGenerator() {
        return this.responseGenerator;
    }

    public CommandsFactory getCommandsFactory() {
        return this.commandsFactory;
    }

    public StateTransferLock getStateTransferLock() {
        return this.stateTransferLock;
    }

    public void cacheComponents() {
        this.cacheMarshaler = this.getOrCreateComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.stateTransferManager = this.getOrCreateComponent(StateTransferManager.class);
        this.responseGenerator = this.getOrCreateComponent(ResponseGenerator.class);
        this.commandsFactory = this.getLocalComponent(CommandsFactory.class);
        this.totalOrderManager = this.getOrCreateComponent(TotalOrderManager.class);
        this.stateTransferLock = this.getOrCreateComponent(StateTransferLock.class);
    }

    @Override
    public ComponentMetadataRepo getComponentMetadataRepo() {
        return this.globalComponents.getComponentMetadataRepo();
    }

    public final TotalOrderManager getTotalOrderManager() {
        return this.totalOrderManager;
    }

    public final org.infinispan.transaction.TransactionTable getTransactionTable() {
        return this.getComponent(TransactionTable.class);
    }
}

