/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.metadata.Metadata;

public class MetadataImmortalCacheValue
extends ImmortalCacheValue
implements MetadataAware {
    Metadata metadata;

    public MetadataImmortalCacheValue(Object value, Metadata metadata) {
        super(value);
        this.metadata = metadata;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new MetadataImmortalCacheEntry(key, this.value, this.metadata);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {" + "value=" + Util.toStr(this.value) + ", metadata=" + this.metadata + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataImmortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, MetadataImmortalCacheValue icv) throws IOException {
            output.writeObject(icv.value);
            output.writeObject(icv.metadata);
        }

        @Override
        public MetadataImmortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            return new MetadataImmortalCacheValue(v, metadata);
        }

        @Override
        public Integer getId() {
            return 80;
        }

        @Override
        public Set<Class<? extends MetadataImmortalCacheValue>> getTypeClasses() {
            return Util.asSet(MetadataImmortalCacheValue.class);
        }
    }
}

