/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class TransientMortalCacheEntry
extends AbstractInternalCacheEntry {
    protected Object value;
    protected long maxIdle = -1L;
    protected long lastUsed;
    protected long lifespan = -1L;
    protected long created;

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long currentTimeMillis) {
        this(key, value, maxIdle, lifespan, currentTimeMillis, currentTimeMillis);
    }

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key);
        this.value = value;
        this.maxIdle = maxIdle;
        this.lifespan = lifespan;
        this.created = created;
        this.lastUsed = lastUsed;
    }

    public void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public long getLifespan() {
        return this.lifespan;
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created, now);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lset = this.lifespan > -1L ? this.created + this.lifespan : -1L;
        long l = muet = this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    public InternalCacheValue toInternalCacheValue() {
        return new TransientMortalCacheValue(this.value, this.created, this.lifespan, this.maxIdle, this.lastUsed);
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final void touch() {
        this.touch(System.currentTimeMillis());
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
        this.reincarnate(System.currentTimeMillis());
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public Object setValue(Object value) {
        this.value = value;
        return this.value;
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().lifespan(this.lifespan).maxIdle(this.maxIdle).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientMortalCacheEntry that = (TransientMortalCacheEntry)o;
        if (this.created != that.created) {
            return false;
        }
        return this.lifespan == that.lifespan;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
        return result;
    }

    @Override
    public TransientMortalCacheEntry clone() {
        return (TransientMortalCacheEntry)super.clone();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, TransientMortalCacheEntry entry) throws IOException {
            output.writeObject(entry.key);
            output.writeObject(entry.value);
            UnsignedNumeric.writeUnsignedLong(output, entry.created);
            output.writeLong(entry.lifespan);
            UnsignedNumeric.writeUnsignedLong(output, entry.lastUsed);
            output.writeLong(entry.maxIdle);
        }

        @Override
        public TransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientMortalCacheEntry(k, v, maxIdle, lifespan, lastUsed, created);
        }

        @Override
        public Integer getId() {
            return 13;
        }

        @Override
        public Set<Class<? extends TransientMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(TransientMortalCacheEntry.class);
        }
    }
}

