/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationChildBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class SingletonStoreConfigurationBuilder<S>
extends AbstractStoreConfigurationChildBuilder<S>
implements Builder<SingletonStoreConfiguration> {
    private boolean enabled = false;
    private long pushStateTimeout = TimeUnit.SECONDS.toMillis(10L);
    private boolean pushStateWhenCoordinator = true;

    SingletonStoreConfigurationBuilder(AbstractStoreConfigurationBuilder<? extends AbstractStoreConfiguration, ?> builder) {
        super(builder);
    }

    public SingletonStoreConfigurationBuilder<S> enable() {
        this.enabled = true;
        return this;
    }

    public SingletonStoreConfigurationBuilder<S> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SingletonStoreConfigurationBuilder<S> disable() {
        this.enabled = false;
        return this;
    }

    public SingletonStoreConfigurationBuilder<S> pushStateTimeout(long l) {
        this.pushStateTimeout = l;
        return this;
    }

    public SingletonStoreConfigurationBuilder<S> pushStateTimeout(long l, TimeUnit unit) {
        return this.pushStateTimeout(unit.toMillis(l));
    }

    public SingletonStoreConfigurationBuilder<S> pushStateWhenCoordinator(boolean b) {
        this.pushStateWhenCoordinator = b;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (globalConfig.transport().transport() == null) {
            throw new CacheConfigurationException("Must have a transport set in the global configuration in order to configure a singleton store");
        }
    }

    @Override
    public SingletonStoreConfiguration create() {
        return new SingletonStoreConfiguration(this.enabled, this.pushStateTimeout, this.pushStateWhenCoordinator);
    }

    @Override
    public SingletonStoreConfigurationBuilder<S> read(SingletonStoreConfiguration template) {
        this.enabled = template.enabled();
        this.pushStateTimeout = template.pushStateTimeout();
        this.pushStateWhenCoordinator = template.pushStateWhenCoordinator();
        return this;
    }

    public String toString() {
        return "SingletonStoreConfigurationBuilder{enabled=" + this.enabled + ", pushStateTimeout=" + this.pushStateTimeout + ", pushStateWhenCoordinator=" + this.pushStateWhenCoordinator + '}';
    }
}

