/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvocationBatchingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<InvocationBatchingConfiguration> {
    private static final Log log = LogFactory.getLog(InvocationBatchingConfigurationBuilder.class);
    boolean enabled = false;

    InvocationBatchingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public InvocationBatchingConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public InvocationBatchingConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public InvocationBatchingConfigurationBuilder enable(boolean enable) {
        this.enabled = enable;
        return this;
    }

    @Override
    public void validate() {
        if (this.enabled && this.getBuilder().transaction().transactionMode != null && this.getBuilder().transaction().transactionMode.equals((Object)TransactionMode.NON_TRANSACTIONAL)) {
            throw log.invocationBatchingNeedsTransactionalCache();
        }
        if (this.enabled && this.getBuilder().transaction().recovery().enabled && !this.getBuilder().transaction().useSynchronization()) {
            throw log.invocationBatchingCannotBeRecoverable();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public InvocationBatchingConfiguration create() {
        return new InvocationBatchingConfiguration(this.enabled);
    }

    public InvocationBatchingConfigurationBuilder read(InvocationBatchingConfiguration template) {
        this.enabled = template.enabled();
        return this;
    }

    public String toString() {
        return "InvocationBatchingConfigurationBuilder{enabled=" + this.enabled + '}';
    }
}

