/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.AbstractTransport;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsBackupResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.infinispan.remoting.transport.jgroups.JGroupsResponseFilterAdapter;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.MarshallerAdapter;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiverRepository;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.tom.TOA;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.TopologyUUID;

public class JGroupsTransport
extends AbstractTransport
implements MembershipListener {
    public static final String CONFIGURATION_STRING = "configurationString";
    public static final String CONFIGURATION_XML = "configurationXml";
    public static final String CONFIGURATION_FILE = "configurationFile";
    public static final String CHANNEL_LOOKUP = "channelLookup";
    protected static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "default-configs/default-jgroups-udp.xml";
    static final Log log = LogFactory.getLog(JGroupsTransport.class);
    static final boolean trace = log.isTraceEnabled();
    protected boolean connectChannel = true;
    protected boolean disconnectChannel = true;
    protected boolean closeChannel = true;
    private CommandAwareRpcDispatcher dispatcher;
    protected TypedProperties props;
    protected InboundInvocationHandler inboundInvocationHandler;
    protected StreamingMarshaller marshaller;
    protected ExecutorService asyncExecutor;
    protected ExecutorService remoteCommandsExecutor;
    protected CacheManagerNotifier notifier;
    private GlobalComponentRegistry gcr;
    private BackupReceiverRepository backupReceiverRepository;
    private TimeService timeService;
    private boolean globalStatsEnabled;
    private MBeanServer mbeanServer;
    private String domain;
    protected Channel channel;
    protected Address address;
    protected Address physicalAddress;
    protected volatile List<Address> members = null;
    protected volatile Address coordinator = null;
    protected volatile boolean isCoordinator = false;
    protected Lock viewUpdateLock = new ReentrantLock();
    protected Condition viewUpdateCondition = this.viewUpdateLock.newCondition();

    public JGroupsTransport(Channel channel) {
        this.channel = channel;
        if (channel == null) {
            throw new IllegalArgumentException("Cannot deal with a null channel!");
        }
        if (channel.isConnected()) {
            throw new IllegalArgumentException("Channel passed in cannot already be connected!");
        }
    }

    public JGroupsTransport() {
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Inject
    public void initialize(@ComponentName(value="org.infinispan.marshaller.global") StreamingMarshaller marshaller, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncExecutor, @ComponentName(value="org.infinispan.executors.remote") ExecutorService remoteCommandsExecutor, InboundInvocationHandler inboundInvocationHandler, CacheManagerNotifier notifier, GlobalComponentRegistry gcr, BackupReceiverRepository backupReceiverRepository, TimeService timeService) {
        this.marshaller = marshaller;
        this.asyncExecutor = asyncExecutor;
        this.remoteCommandsExecutor = remoteCommandsExecutor;
        this.inboundInvocationHandler = inboundInvocationHandler;
        this.notifier = notifier;
        this.gcr = gcr;
        this.backupReceiverRepository = backupReceiverRepository;
        this.timeService = timeService;
    }

    @Override
    public void start() {
        this.props = TypedProperties.toTypedProperties(this.configuration.transport().properties());
        if (log.isInfoEnabled()) {
            log.startingJGroupsChannel(this.configuration.transport().clusterName());
        }
        this.initChannelAndRPCDispatcher();
        this.startJGroupsChannelIfNeeded();
        this.waitForChannelToConnect();
    }

    protected void startJGroupsChannelIfNeeded() {
        String clusterName = this.configuration.transport().clusterName();
        if (this.connectChannel) {
            try {
                this.channel.connect(clusterName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start JGroups Channel", e);
            }
            try {
                this.globalStatsEnabled = this.configuration.globalJmxStatistics().enabled();
                if (this.globalStatsEnabled) {
                    String groupName = String.format("type=channel,cluster=%s", ObjectName.quote(clusterName));
                    this.mbeanServer = JmxUtil.lookupMBeanServer(this.configuration);
                    this.domain = JmxUtil.buildJmxDomain(this.configuration, this.mbeanServer, groupName);
                    JmxConfigurator.registerChannel((JChannel)this.channel, this.mbeanServer, this.domain, clusterName, true);
                }
            }
            catch (Exception e) {
                throw new CacheException("Channel connected, but unable to register MBeans", e);
            }
        }
        this.address = JGroupsTransport.fromJGroupsAddress(this.channel.getAddress());
        if (!this.connectChannel) {
            this.viewAccepted(this.channel.getView());
        }
        if (log.isInfoEnabled()) {
            log.localAndPhysicalAddress(clusterName, this.getAddress(), this.getPhysicalAddresses());
        }
    }

    @Override
    public int getViewId() {
        if (this.channel == null) {
            throw new CacheException("The cache has been stopped and invocations are not allowed!");
        }
        View view = this.channel.getView();
        if (view == null) {
            return -1;
        }
        return (int)view.getViewId().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForView(int viewId) throws InterruptedException {
        if (this.channel == null) {
            return;
        }
        log.tracef("Waiting on view %d being accepted", (Object)viewId);
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.getViewId() < viewId) {
                this.viewUpdateCondition.await();
            }
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        String clusterName = this.configuration.transport().clusterName();
        try {
            if (this.disconnectChannel && this.channel != null && this.channel.isConnected()) {
                log.disconnectJGroups(clusterName);
                if (this.globalStatsEnabled) {
                    JmxConfigurator.unregisterChannel((JChannel)this.channel, this.mbeanServer, this.domain, this.channel.getClusterName());
                }
                this.channel.disconnect();
            }
            if (this.closeChannel && this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (Exception toLog) {
            log.problemClosingChannel(toLog, clusterName);
        }
        if (this.dispatcher != null) {
            log.stoppingRpcDispatcher(clusterName);
            this.dispatcher.stop();
            if (this.channel != null) {
                UpHandler handler = this.channel.getUpHandler();
                if (handler instanceof Muxer) {
                    Muxer mux = (Muxer)((Object)handler);
                    mux.setDefaultHandler(null);
                } else {
                    this.channel.setUpHandler(null);
                }
            }
        }
        this.channel = null;
        this.members = InfinispanCollections.emptyList();
        this.coordinator = null;
        this.isCoordinator = false;
        this.dispatcher = null;
        this.viewUpdateLock.lock();
        try {
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    protected void initChannel() {
        final TransportConfiguration transportCfg = this.configuration.transport();
        if (this.channel == null) {
            this.buildChannel();
            String transportNodeName = transportCfg.nodeName();
            if (transportNodeName != null && transportNodeName.length() > 0) {
                long range = 65534L;
                long randomInRange = (long)(Math.random() * (double)range % (double)range) + 1L;
                transportNodeName = transportNodeName + "-" + randomInRange;
                this.channel.setName(transportNodeName);
            }
        }
        this.channel.setDiscardOwnMessages(false);
        if (transportCfg.hasTopologyInfo()) {
            if (this.connectChannel) {
                ((JChannel)this.channel).setAddressGenerator(new AddressGenerator(){

                    @Override
                    public org.jgroups.Address generateAddress() {
                        return TopologyUUID.randomUUID(JGroupsTransport.this.channel.getName(), transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId());
                    }
                });
            } else if (this.channel.getAddress() instanceof TopologyUUID) {
                TopologyUUID topologyAddress = (TopologyUUID)this.channel.getAddress();
                if (!(transportCfg.siteId().equals(topologyAddress.getSiteId()) && transportCfg.rackId().equals(topologyAddress.getRackId()) && transportCfg.machineId().equals(topologyAddress.getMachineId()))) {
                    throw new CacheException("Topology information does not match the one set by the provided JGroups channel");
                }
            } else {
                throw new CacheException("JGroups address does not contain topology coordinates");
            }
        }
    }

    private void initChannelAndRPCDispatcher() throws CacheException {
        this.initChannel();
        this.dispatcher = new CommandAwareRpcDispatcher(this.channel, this, this.asyncExecutor, this.remoteCommandsExecutor, this.inboundInvocationHandler, this.gcr, this.backupReceiverRepository);
        MarshallerAdapter adapter = new MarshallerAdapter(this.marshaller);
        this.dispatcher.setRequestMarshaller(adapter);
        this.dispatcher.setResponseMarshaller(adapter);
        this.dispatcher.start();
    }

    private void buildChannel() {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        if (this.props != null) {
            String cfg;
            if (this.props.containsKey(CHANNEL_LOOKUP)) {
                String channelLookupClassName = this.props.getProperty(CHANNEL_LOOKUP);
                try {
                    JGroupsChannelLookup lookup = (JGroupsChannelLookup)Util.getInstance(channelLookupClassName, this.configuration.classLoader());
                    this.channel = lookup.getJGroupsChannel(this.props);
                    this.connectChannel = lookup.shouldConnect();
                    this.disconnectChannel = lookup.shouldDisconnect();
                    this.closeChannel = lookup.shouldClose();
                }
                catch (ClassCastException e) {
                    log.wrongTypeForJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException(e);
                }
                catch (Exception e) {
                    log.errorInstantiatingJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException(e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_FILE)) {
                cfg = this.props.getProperty(CONFIGURATION_FILE);
                Collection<URL> confs = null;
                try {
                    confs = fileLookup.lookupFileLocations(cfg, this.configuration.classLoader());
                }
                catch (IOException io) {
                    // empty catch block
                }
                if (confs.isEmpty()) {
                    throw new CacheConfigurationException("configurationFile property specifies value " + cfg + " that could not be read!", new FileNotFoundException(cfg));
                }
                if (confs.size() > 1) {
                    log.ambiguousConfigurationFiles(Util.toStr(confs));
                }
                try {
                    this.channel = new JChannel(confs.iterator().next());
                }
                catch (Exception e) {
                    log.errorCreatingChannelFromConfigFile(cfg);
                    throw new CacheException(e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_XML)) {
                cfg = this.props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel(XmlConfigHelper.stringToElement(cfg));
                }
                catch (Exception e) {
                    log.errorCreatingChannelFromXML(cfg);
                    throw new CacheException(e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_STRING)) {
                cfg = this.props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel(cfg);
                }
                catch (Exception e) {
                    log.errorCreatingChannelFromConfigString(cfg);
                    throw new CacheException(e);
                }
            }
        }
        if (this.channel == null) {
            log.unableToUseJGroupsPropertiesProvided(this.props);
            try {
                this.channel = new JChannel(fileLookup.lookupFileLocation(DEFAULT_JGROUPS_CONFIGURATION_FILE, this.configuration.classLoader()));
            }
            catch (Exception e) {
                throw new CacheException("Unable to start JGroups channel", e);
            }
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    @Override
    public Address getCoordinator() {
        return this.coordinator;
    }

    public void waitForChannelToConnect() {
        try {
            this.waitForView(0);
        }
        catch (InterruptedException e) {
            log.interruptedWaitingForCoordinator(e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public List<Address> getMembers() {
        return this.members != null ? this.members : InfinispanCollections.emptyList();
    }

    @Override
    public boolean isMulticastCapable() {
        return this.channel.getProtocolStack().getTransport().supportsMulticasting();
    }

    @Override
    public Address getAddress() {
        if (this.address == null && this.channel != null) {
            this.address = JGroupsTransport.fromJGroupsAddress(this.channel.getAddress());
        }
        return this.address;
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        if (this.physicalAddress == null && this.channel != null) {
            org.jgroups.Address addr = (org.jgroups.Address)this.channel.down(new Event(87, this.channel.getAddress()));
            if (addr == null) {
                return InfinispanCollections.emptyList();
            }
            this.physicalAddress = new JGroupsAddress(addr);
        }
        return Collections.singletonList(this.physicalAddress);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean totalOrder, boolean anycast) throws Exception {
        Map<Address, Response> responses;
        boolean broadcast;
        boolean asyncMarshalling;
        boolean ignoreLeavers;
        if (recipients != null && recipients.isEmpty()) {
            log.trace("Destination list is empty: no need to send message");
            return InfinispanCollections.emptyMap();
        }
        if (trace) {
            log.tracef("dests=%s, command=%s, mode=%s, timeout=%s", new Object[]{recipients, rpcCommand, mode, timeout});
        }
        Address self = this.getAddress();
        boolean bl = ignoreLeavers = mode == ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS || mode == ResponseMode.WAIT_FOR_VALID_RESPONSE;
        if (mode.isSynchronous() && recipients != null && !this.getMembers().containsAll(recipients)) {
            if (ignoreLeavers) {
                recipients = new HashSet<Address>(recipients);
                recipients.retainAll(this.getMembers());
            } else {
                throw new SuspectException("One or more nodes have left the cluster while replicating command " + rpcCommand);
            }
        }
        boolean bl2 = asyncMarshalling = mode == ResponseMode.ASYNCHRONOUS;
        if (!(usePriorityQueue || ResponseMode.SYNCHRONOUS != mode && ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS != mode)) {
            usePriorityQueue = true;
        }
        List<org.jgroups.Address> jgAddressList = this.toJGroupsAddressListExcludingSelf(recipients, totalOrder);
        int membersSize = this.members.size();
        boolean bl3 = broadcast = jgAddressList == null || recipients.size() == membersSize;
        if (!totalOrder && (membersSize < 3 || jgAddressList != null && jgAddressList.size() < 2)) {
            broadcast = false;
        }
        RspList<Object> rsps = null;
        Response singleResponse = null;
        org.jgroups.Address singleJGAddress = null;
        if (broadcast || totalOrder && !anycast) {
            rsps = this.dispatcher.broadcastRemoteCommands(rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, usePriorityQueue, this.toJGroupsFilter(responseFilter), asyncMarshalling, ignoreLeavers, totalOrder);
        } else if (totalOrder && anycast) {
            rsps = this.dispatcher.invokeRemoteCommands(jgAddressList, rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, usePriorityQueue, this.toJGroupsFilter(responseFilter), asyncMarshalling, ignoreLeavers, totalOrder);
        } else if (jgAddressList == null || !jgAddressList.isEmpty()) {
            boolean singleRecipient = !ignoreLeavers && jgAddressList != null && jgAddressList.size() == 1;
            boolean skipRpc = false;
            if (jgAddressList == null) {
                ArrayList<Address> others = new ArrayList<Address>(this.members);
                others.remove(self);
                skipRpc = others.isEmpty();
                boolean bl4 = singleRecipient = !ignoreLeavers && others.size() == 1;
                if (singleRecipient) {
                    singleJGAddress = JGroupsTransport.toJGroupsAddress(others.get(0));
                }
            }
            if (!skipRpc) {
                if (singleRecipient) {
                    if (singleJGAddress == null) {
                        singleJGAddress = jgAddressList.get(0);
                    }
                    singleResponse = this.dispatcher.invokeRemoteCommand(singleJGAddress, rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, usePriorityQueue, asyncMarshalling);
                } else {
                    rsps = this.dispatcher.invokeRemoteCommands(jgAddressList, rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, usePriorityQueue, this.toJGroupsFilter(responseFilter), asyncMarshalling, ignoreLeavers, totalOrder);
                }
            }
        }
        if (mode.isAsynchronous()) {
            return InfinispanCollections.emptyMap();
        }
        if (rsps == null) {
            responses = singleJGAddress == null || singleResponse == null && rpcCommand instanceof ClusteredGetCommand ? InfinispanCollections.emptyMap() : Collections.singletonMap(JGroupsTransport.fromJGroupsAddress(singleJGAddress), singleResponse);
        } else {
            HashMap<Address, Response> retval = new HashMap<Address, Response>(rsps.size());
            boolean noValidResponses = true;
            for (Rsp<Object> rsp : rsps.values()) {
                noValidResponses &= this.parseResponseAndAddToResponseList(rsp.getValue(), rsp.getException(), retval, rsp.wasSuspected(), rsp.wasReceived(), JGroupsTransport.fromJGroupsAddress(rsp.getSender()), responseFilter != null, ignoreLeavers);
            }
            if (noValidResponses) {
                throw new TimeoutException("Timed out waiting for valid responses!");
            }
            responses = retval;
        }
        return responses;
    }

    @Override
    public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand rpcCommand) throws Exception {
        log.tracef("About to send to backups %s, command %s", (Object)backups, (Object)rpcCommand);
        Buffer buf = CommandAwareRpcDispatcher.marshallCall(this.dispatcher.getMarshaller(), rpcCommand);
        HashMap<XSiteBackup, Future<Object>> syncBackupCalls = new HashMap<XSiteBackup, Future<Object>>(backups.size());
        for (XSiteBackup xsb : backups) {
            SiteMaster recipient = new SiteMaster(xsb.getSiteName());
            if (xsb.isSync()) {
                RequestOptions sync = new RequestOptions(org.jgroups.blocks.ResponseMode.GET_ALL, xsb.getTimeout());
                syncBackupCalls.put(xsb, this.dispatcher.sendMessageWithFuture(CommandAwareRpcDispatcher.constructMessage(buf, recipient, true, org.jgroups.blocks.ResponseMode.GET_ALL, false, false), sync));
                continue;
            }
            RequestOptions async = new RequestOptions(org.jgroups.blocks.ResponseMode.GET_NONE, xsb.getTimeout());
            this.dispatcher.sendMessage(CommandAwareRpcDispatcher.constructMessage(buf, recipient, false, org.jgroups.blocks.ResponseMode.GET_NONE, false, false), async);
        }
        return new JGroupsBackupResponse(syncBackupCalls, this.timeService);
    }

    private static org.jgroups.blocks.ResponseMode toJGroupsMode(ResponseMode mode) {
        switch (mode) {
            case ASYNCHRONOUS: 
            case ASYNCHRONOUS_WITH_SYNC_MARSHALLING: {
                return org.jgroups.blocks.ResponseMode.GET_NONE;
            }
            case SYNCHRONOUS: 
            case SYNCHRONOUS_IGNORE_LEAVERS: {
                return org.jgroups.blocks.ResponseMode.GET_ALL;
            }
            case WAIT_FOR_VALID_RESPONSE: {
                return org.jgroups.blocks.ResponseMode.GET_FIRST;
            }
        }
        throw new CacheException("Unknown response mode " + (Object)((Object)mode));
    }

    private RspFilter toJGroupsFilter(ResponseFilter responseFilter) {
        return responseFilter == null ? null : new JGroupsResponseFilterAdapter(responseFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewAccepted(View newView) {
        boolean hasNotifier;
        log.debugf("New view accepted: %s", (Object)newView);
        List<org.jgroups.Address> newMembers = newView.getMembers();
        if (newMembers == null || newMembers.isEmpty()) {
            log.debugf("Received null or empty member list from JGroups channel: " + newView, new Object[0]);
            return;
        }
        List<Address> oldMembers = this.members;
        this.members = JGroupsTransport.fromJGroupsAddressList(newMembers);
        if (log.isDebugEnabled() && oldMembers != null) {
            ArrayList<Address> joined = new ArrayList<Address>(this.members);
            joined.removeAll(oldMembers);
            ArrayList<Address> left = new ArrayList<Address>(oldMembers);
            left.removeAll(this.members);
            log.debugf("Joined: %s, Left: %s", (Object)joined, (Object)left);
        }
        this.coordinator = JGroupsTransport.fromJGroupsAddress(newView.getCreator());
        this.isCoordinator = this.coordinator != null && this.coordinator.equals(this.getAddress());
        this.viewUpdateLock.lock();
        try {
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
        }
        boolean bl = hasNotifier = this.notifier != null;
        if (hasNotifier) {
            Notify n;
            String clusterName = this.configuration.transport().clusterName();
            if (newView instanceof MergeView) {
                log.receivedMergedView(clusterName, newView);
                n = new NotifyMerge();
            } else {
                log.receivedClusterView(clusterName, newView);
                n = new NotifyViewChange();
            }
            n.emitNotification(oldMembers, newView);
        }
    }

    @Override
    public void suspect(org.jgroups.Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void unblock() {
    }

    protected static org.jgroups.Address toJGroupsAddress(Address a) {
        return ((JGroupsAddress)a).address;
    }

    static Address fromJGroupsAddress(org.jgroups.Address addr) {
        if (addr instanceof ExtendedUUID) {
            return new JGroupsTopologyAwareAddress((ExtendedUUID)addr);
        }
        return new JGroupsAddress(addr);
    }

    private List<org.jgroups.Address> toJGroupsAddressListExcludingSelf(Collection<Address> list, boolean totalOrder) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return InfinispanCollections.emptyList();
        }
        ArrayList<org.jgroups.Address> retval = new ArrayList<org.jgroups.Address>(list.size());
        boolean ignoreSelf = !totalOrder;
        Address self = this.getAddress();
        for (Address a : list) {
            if (!ignoreSelf || !a.equals(self)) {
                retval.add(JGroupsTransport.toJGroupsAddress(a));
                continue;
            }
            ignoreSelf = false;
        }
        return retval;
    }

    private static List<Address> fromJGroupsAddressList(List<org.jgroups.Address> list) {
        if (list == null || list.isEmpty()) {
            return InfinispanCollections.emptyList();
        }
        ArrayList<Address> retval = new ArrayList<Address>(list.size());
        for (org.jgroups.Address a : list) {
            retval.add(JGroupsTransport.fromJGroupsAddress(a));
        }
        return Collections.unmodifiableList(retval);
    }

    public CommandAwareRpcDispatcher getCommandAwareRpcDispatcher() {
        return this.dispatcher;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public final void checkTotalOrderSupported() {
        if (this.channel.getProtocolStack().findProtocol((Class<?>)TOA.class) == null) {
            throw new CacheConfigurationException("In order to support total order based transaction, the TOA protocol must be present in the JGroups's config.");
        }
    }

    private class NotifyMerge
    implements Notify {
        private NotifyMerge() {
        }

        @Override
        public void emitNotification(List<Address> oldMembers, View newView) {
            MergeView mv = (MergeView)newView;
            Address address = JGroupsTransport.this.getAddress();
            int viewId = (int)newView.getVid().getId();
            JGroupsTransport.this.notifier.notifyMerge(JGroupsTransport.this.members, oldMembers, address, viewId, this.getSubgroups(mv.getSubgroups()));
        }

        private List<List<Address>> getSubgroups(List<View> subviews) {
            ArrayList<List<Address>> l = new ArrayList<List<Address>>(subviews.size());
            for (View v : subviews) {
                l.add(JGroupsTransport.fromJGroupsAddressList(v.getMembers()));
            }
            return l;
        }
    }

    private class NotifyViewChange
    implements Notify {
        private NotifyViewChange() {
        }

        @Override
        public void emitNotification(List<Address> oldMembers, View newView) {
            JGroupsTransport.this.notifier.notifyViewChange(JGroupsTransport.this.members, oldMembers, JGroupsTransport.this.getAddress(), (int)newView.getVid().getId());
        }
    }

    private static interface Notify {
        public void emitNotification(List<Address> var1, View var2);
    }
}

