/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Random;
import org.jgroups.Event;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class DELAY
extends Protocol {
    private static final Random randomNumberGenerator = new Random();
    @Property(description="Upper bound of number of milliseconds to delay passing a message up the stack (exclusive)")
    protected int in_delay;
    @Property(description="Upper bound number of milliseconds to delay passing a message down the stack (exclusive)")
    protected int out_delay;
    @Property(description="Number of nanoseconds to delay passing a message up the stack")
    protected int in_delay_nanos;
    @Property(description="Number of nanoseconds to delay passing a message down the stack")
    protected int out_delay_nanos;

    public int getInDelay() {
        return this.in_delay;
    }

    public void setInDelay(int in_delay) {
        this.in_delay = in_delay;
    }

    public int getOutDelay() {
        return this.out_delay;
    }

    public void setOutDelay(int out_delay) {
        this.out_delay = out_delay;
    }

    public int getInDelayNanos() {
        return this.in_delay_nanos;
    }

    public void setInDelayNanos(int in_delay_nanos) {
        this.in_delay_nanos = in_delay_nanos;
    }

    public int getOutDelayNanos() {
        return this.out_delay_nanos;
    }

    public void setOutDelayNanos(int out_delay_nanos) {
        this.out_delay_nanos = out_delay_nanos;
    }

    @Override
    public Object down(Event evt) {
        if (DELAY.isMessage(evt)) {
            DELAY.sleep(this.out_delay, this.out_delay_nanos);
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        if (DELAY.isMessage(evt)) {
            DELAY.sleep(this.in_delay, this.in_delay_nanos);
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        DELAY.sleep(this.in_delay, this.in_delay_nanos);
        this.up_prot.up(batch);
    }

    private static boolean isMessage(Event evt) {
        return evt.getType() == 1;
    }

    private static int computeDelay(int n) {
        if (n <= 1) {
            return 0;
        }
        return randomNumberGenerator.nextInt(n);
    }

    private static void sleep(int variable_milliseconds_delay, int nano_delay) {
        int millis = DELAY.computeDelay(variable_milliseconds_delay);
        if (millis != 0 || nano_delay != 0) {
            Util.sleep(millis, nano_delay);
        }
    }
}

