/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partionhandling.impl;

import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.partionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.transport.Transport;

public class PartitionHandlingInterceptor
extends CommandInterceptor {
    PartitionHandlingManager partitionHandlingManager;
    private Transport transport;
    private ClusteringDependentLogic cdl;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager, Transport transport, ClusteringDependentLogic cdl) {
        this.partitionHandlingManager = partitionHandlingManager;
        this.transport = transport;
        this.cdl = cdl;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitRemoveCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitReplaceCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        for (Object k : command.getAffectedKeys()) {
            this.partitionHandlingManager.checkWrite(k);
        }
        return super.visitPutMapCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        this.partitionHandlingManager.checkClear();
        return super.visitClearCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitApplyDeltaCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object result;
        Object key = command.getKey();
        try {
            result = super.visitGetKeyValueCommand(ctx, command);
        }
        catch (RpcException e) {
            throw this.getLog().degradedModeKeyUnavailable(key);
        }
        this.partitionHandlingManager.checkRead(key);
        if (result == null && !InfinispanCollections.containsAny(this.transport.getMembers(), this.cdl.getOwners(key))) {
            throw this.getLog().degradedModeKeyUnavailable(key);
        }
        return result;
    }
}

