/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.group.GroupFilter;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="CacheLoader", description="Component that handles loading entries from a CacheStore into memory.")
public class CacheLoaderInterceptor
extends JmxStatsCommandInterceptor {
    private final AtomicLong cacheLoads = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    protected PersistenceManager persistenceManager;
    protected CacheNotifier notifier;
    protected volatile boolean enabled = true;
    protected EntryFactory entryFactory;
    private TimeService timeService;
    private InternalEntryFactory iceFactory;
    private DataContainer dataContainer;
    private GroupManager groupManager;
    private static final Log log = LogFactory.getLog(CacheLoaderInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void injectDependencies(PersistenceManager clm, EntryFactory entryFactory, CacheNotifier notifier, TimeService timeService, InternalEntryFactory iceFactory, DataContainer dataContainer, GroupManager groupManager) {
        this.persistenceManager = clm;
        this.notifier = notifier;
        this.entryFactory = entryFactory;
        this.timeService = timeService;
        this.iceFactory = iceFactory;
        this.dataContainer = dataContainer;
        this.groupManager = groupManager;
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeeded(ctx, key, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeeded(ctx, key, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Object[] keys;
        if (this.enabled && (keys = command.getKeys()) != null && keys.length > 0) {
            for (Object key : command.getKeys()) {
                this.loadIfNeeded(ctx, key, command);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        Object keys = super.visitKeySetCommand(ctx, command);
        if (this.enabled && !this.hasSkipLoadFlag(command)) {
            Set keysSet = (Set)keys;
            final ConcurrentHashSet union = new ConcurrentHashSet();
            for (Object k : keysSet) {
                union.add(k);
            }
            this.persistenceManager.processOnAllStores(new CollectionKeyFilter(union), new AdvancedCacheLoader.CacheLoaderTask(){

                public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                    union.add(marshalledEntry.getKey());
                }
            }, false, false);
            return Collections.unmodifiableSet(union);
        }
        return keys;
    }

    @Override
    public Object visitGetKeysInGroupCommand(final InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        String groupName = command.getGroupName();
        if (!command.isGroupOwner() || !this.enabled || this.hasSkipLoadFlag(command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        CompositeKeyFilter keyFilter = new CompositeKeyFilter(new GroupFilter(groupName, this.groupManager), new CollectionKeyFilter<Object>(ctx.getLookedUpEntries().keySet()));
        this.persistenceManager.processOnAllStores(keyFilter, new AdvancedCacheLoader.CacheLoaderTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                InvocationContext invocationContext = ctx;
                synchronized (invocationContext) {
                    CacheLoaderInterceptor.this.entryFactory.wrapEntryForReading(ctx, marshalledEntry.getKey(), PersistenceUtil.convert(marshalledEntry, CacheLoaderInterceptor.this.iceFactory)).setSkipLookup(true);
                }
            }
        }, true, true);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        Object entrySet = super.visitEntrySetCommand(ctx, command);
        if (this.enabled && !this.hasSkipLoadFlag(command)) {
            final ConcurrentHashSet<InternalCacheEntry> union = new ConcurrentHashSet<InternalCacheEntry>();
            ConcurrentHashSet processedKeys = new ConcurrentHashSet();
            for (InternalCacheEntry ice : (Set)entrySet) {
                processedKeys.add(ice.getKey());
            }
            this.persistenceManager.processOnAllStores(new CollectionKeyFilter(processedKeys), new AdvancedCacheLoader.CacheLoaderTask(){

                public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                    union.add(CacheLoaderInterceptor.this.iceFactory.create(marshalledEntry.getKey(), marshalledEntry.getValue(), marshalledEntry.getMetadata()));
                }
            }, true, true);
            for (InternalCacheEntry ice : (Set)entrySet) {
                union.add(ice);
            }
            return Collections.unmodifiableSet(union);
        }
        return entrySet;
    }

    @Override
    public Object visitValuesCommand(InvocationContext ctx, ValuesCommand command) throws Throwable {
        Object values = super.visitValuesCommand(ctx, command);
        if (this.enabled && !this.hasSkipLoadFlag(command)) {
            final ConcurrentLinkedQueue result = new ConcurrentLinkedQueue();
            this.persistenceManager.processOnAllStores(null, new AdvancedCacheLoader.CacheLoaderTask(){

                public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                    result.add(marshalledEntry.getValue());
                }
            }, true, false);
            result.addAll((Collection)values);
            return result;
        }
        return values;
    }

    protected final boolean isDeltaWrite(WriteCommand cmd) {
        return cmd.hasFlag(Flag.DELTA_WRITE);
    }

    protected final boolean isConditional(WriteCommand cmd) {
        return cmd.isConditional();
    }

    protected final boolean hasSkipLoadFlag(LocalFlagAffectedCommand cmd) {
        return cmd.hasFlag(Flag.SKIP_CACHE_LOAD);
    }

    protected final boolean hasIgnoreReturnValueFlag(LocalFlagAffectedCommand cmd) {
        return cmd.hasFlag(Flag.IGNORE_RETURN_VALUES);
    }

    protected boolean canLoad(Object key) {
        return true;
    }

    protected final Boolean loadIfNeeded(InvocationContext ctx, Object key, FlagAffectedCommand cmd) throws Throwable {
        if (this.skipLoad(cmd, key, ctx)) {
            return null;
        }
        boolean isDelta = cmd instanceof ApplyDeltaCommand;
        AtomicReference<Boolean> isLoaded = new AtomicReference<Boolean>();
        InternalCacheEntry entry = PersistenceUtil.loadAndStoreInDataContainer(this.dataContainer, this.persistenceManager, key, ctx, this.timeService, isLoaded);
        if (entry != null) {
            CacheEntry wrappedEntry = this.wrapInternalCacheEntry(ctx, key, cmd, entry, isDelta);
            if (isLoaded.get() == Boolean.TRUE) {
                this.recordLoadedEntry(ctx, key, wrappedEntry, entry, cmd);
            }
        }
        return isLoaded.get();
    }

    private boolean skipLoad(FlagAffectedCommand cmd, Object key, InvocationContext ctx) {
        boolean skip;
        if (!this.shouldAttemptLookup(ctx.lookupEntry(key))) {
            if (trace) {
                log.tracef("Skip load for command %s. Entry already exists in context.", (Object)cmd);
            }
            return true;
        }
        if (!this.canLoad(key)) {
            if (trace) {
                log.tracef("Skip load for command %s. Cannot load the key.", (Object)cmd);
            }
            return true;
        }
        if (cmd instanceof WriteCommand) {
            skip = this.skipLoadForWriteCommand((WriteCommand)cmd, key, ctx);
            if (trace) {
                log.tracef("Skip load for write command %s? %s", (Object)cmd, (Object)skip);
            }
        } else {
            skip = this.hasSkipLoadFlag(cmd);
            if (trace) {
                log.tracef("Skip load for command %s?. %s", (Object)cmd, (Object)skip);
            }
        }
        return skip;
    }

    protected boolean skipLoadForWriteCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        if (this.isDeltaWrite(cmd)) {
            if (trace) {
                log.tracef("Don't skip load for command %s. Value is needed!", (Object)cmd);
            }
            return false;
        }
        if (this.isConditional(cmd)) {
            boolean skip = this.hasSkipLoadFlag(cmd);
            if (trace) {
                log.tracef("Skip load for conditional command %s? %s", (Object)cmd, (Object)skip);
            }
            return skip;
        }
        return this.hasSkipLoadFlag(cmd) || this.hasIgnoreReturnValueFlag(cmd);
    }

    private CacheEntry wrapInternalCacheEntry(InvocationContext ctx, Object key, FlagAffectedCommand cmd, InternalCacheEntry ice, boolean isDelta) {
        if (isDelta) {
            ctx.putLookedUpEntry(key, ice);
            return this.entryFactory.wrapEntryForDelta(ctx, key, ((ApplyDeltaCommand)cmd).getDelta());
        }
        return this.entryFactory.wrapEntryForPut(ctx, key, ice, false, cmd, false);
    }

    private boolean shouldAttemptLookup(CacheEntry e) {
        return e == null || (e.isNull() || e.getValue() == null) && !e.skipLookup();
    }

    private void recordLoadedEntry(InvocationContext ctx, Object key, CacheEntry entry, InternalCacheEntry loadedEntry, FlagAffectedCommand cmd) {
        boolean entryExists;
        boolean bl = entryExists = loadedEntry != null;
        if (trace) {
            log.trace("Entry exists in loader? " + entryExists);
        }
        if (this.getStatisticsEnabled()) {
            if (entryExists) {
                this.cacheLoads.incrementAndGet();
            } else {
                this.cacheMisses.incrementAndGet();
            }
        }
        if (entryExists) {
            Object value = loadedEntry.getValue();
            this.sendNotification(key, value, true, ctx, cmd);
            entry.setValue(value);
            Metadata metadata = cmd.getMetadata();
            Metadata loadedMetadata = loadedEntry.getMetadata();
            if (metadata != null && loadedMetadata != null) {
                metadata = Metadatas.applyVersion(loadedMetadata, metadata);
            } else if (metadata == null) {
                metadata = loadedMetadata;
            }
            entry.setMetadata(metadata);
            entry.setValid(true);
            this.sendNotification(key, value, false, ctx, cmd);
        }
    }

    protected void sendNotification(Object key, Object value, boolean pre, InvocationContext ctx, FlagAffectedCommand cmd) {
        this.notifier.notifyCacheEntryLoaded(key, value, pre, ctx, cmd);
    }

    private void loadIfNeededAndUpdateStats(InvocationContext ctx, Object key, FlagAffectedCommand cmd) throws Throwable {
        Boolean found = this.loadIfNeeded(ctx, key, cmd);
        if (found == Boolean.FALSE && this.getStatisticsEnabled()) {
            this.cacheMisses.incrementAndGet();
        }
    }

    @ManagedAttribute(description="Number of entries loaded from cache store", displayName="Number of cache store loads", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderLoads() {
        return this.cacheLoads.get();
    }

    @ManagedAttribute(description="Number of entries that did not exist in cache store", displayName="Number of cache store load misses", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderMisses() {
        return this.cacheMisses.get();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics")
    public void resetStatistics() {
        this.cacheLoads.set(0L);
        this.cacheMisses.set(0L);
    }

    @ManagedAttribute(description="Returns a collection of cache loader types which are configured and enabled", displayName="Returns a collection of cache loader types which are configured and enabled", displayType=DisplayType.DETAIL)
    public Collection<String> getStores() {
        if (this.enabled && this.cacheConfiguration.persistence().usingStores()) {
            return this.persistenceManager.getStoresAsString();
        }
        return InfinispanCollections.emptySet();
    }

    @ManagedOperation(description="Disable all stores of a given type, where type is a fully qualified class name of the cache loader to disable", displayName="Disable all stores of a given type")
    public void disableStore(@Parameter(name="storeType", description="Fully qualified class name of a store implementation") String storeType) {
        if (this.enabled) {
            this.persistenceManager.disableStore(storeType);
        }
    }

    public void disableInterceptor() {
        this.enabled = false;
    }
}

