/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ec2demo;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.ec2demo.CacheBuilder;
import org.infinispan.ec2demo.Nucleotide_Protein_Element;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ProteinCache {
    private static final Log log = LogFactory.getLog(ProteinCache.class);
    private Cache<String, Nucleotide_Protein_Element> myCache;

    public ProteinCache(CacheBuilder cacheManger) throws IOException {
        this.myCache = cacheManger.getCacheManager().getCache("ProteinCache");
    }

    public void addToCache(Nucleotide_Protein_Element value) {
        if (value == null) {
            return;
        }
        String myKey = value.getGenbankAccessionNumber();
        if (myKey == null || myKey.isEmpty()) {
            log.error((Object)("Invalid record " + value));
        } else {
            this.myCache.put((Object)value.getGenbankAccessionNumber(), (Object)value);
        }
    }

    public int getCacheSize() {
        return this.myCache.size();
    }

    public Nucleotide_Protein_Element getProteinDetails(String GBAN) {
        return (Nucleotide_Protein_Element)this.myCache.get((Object)GBAN);
    }

    public Cache<String, Nucleotide_Protein_Element> getCache() {
        return this.myCache;
    }
}

