/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ec2demo;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.infinispan.ec2demo.CacheBuilder;
import org.infinispan.ec2demo.Nucleotide_Protein_Element;

public class NucleotideCache {
    Logger myLogger = Logger.getLogger(NucleotideCache.class);
    private Cache<String, Nucleotide_Protein_Element> myCache;

    public NucleotideCache(CacheBuilder cacheManger) throws IOException {
        this.myCache = cacheManger.getCacheManager().getCache("NucleotideCache");
    }

    public void addToCache(Nucleotide_Protein_Element value) {
        if (value == null) {
            return;
        }
        String myKey = value.getGenbankAccessionNumber();
        if (myKey == null || myKey.isEmpty()) {
            this.myLogger.error((Object)("Invalid record " + value));
        } else {
            this.myCache.put((Object)value.getGenbankAccessionNumber(), (Object)value);
        }
    }

    public int getCacheSize() {
        return this.myCache.size();
    }

    public Nucleotide_Protein_Element getNucleotideDetails(String GBAN) {
        Nucleotide_Protein_Element myVR = (Nucleotide_Protein_Element)this.myCache.get((Object)GBAN);
        return myVR;
    }

    public Cache getCache() {
        return this.myCache;
    }
}

