/**
 * 
 */
package org.infinispan.ec2demo;

import java.io.IOException;
import org.apache.log4j.*;
import org.infinispan.Cache;

/**
 * @author noconnor@redhat.com
 * 
 */
public class NucleotideCache {
	Logger myLogger = Logger.getLogger(NucleotideCache.class);
	private Cache<String, Nucleotide_Protein_Element> myCache;

	public NucleotideCache(CacheBuilder cacheManger) throws IOException {
		myCache = cacheManger.getCacheManager().getCache("NucleotideCache");
	}

	public void addToCache(Nucleotide_Protein_Element value) {
		if (value == null)
			return;
		String myKey = value.getGenbankAccessionNumber();
		if ((myKey == null) || (myKey.isEmpty())) {
			myLogger.error("Invalid record " + value);
		} else {
			myCache.put(value.getGenbankAccessionNumber(), value);
		}
	}

	public int getCacheSize() {
		return myCache.size();
	}

	public Nucleotide_Protein_Element getNucleotideDetails(String GBAN) {
		Nucleotide_Protein_Element myVR = myCache.get(GBAN);
		return myVR;
	}
	
	public Cache getCache(){
		return myCache;
	}
}
