/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.io.AbstractConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.configuration.io.URLConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.xml.MXParser;
import org.infinispan.commons.configuration.io.xml.XmlPullParser;
import org.infinispan.commons.configuration.io.xml.XmlPullParserException;
import org.infinispan.commons.util.SimpleImmutableEntry;
import org.infinispan.commons.util.Util;

public class XmlConfigurationReader
extends AbstractConfigurationReader {
    public static final String XINCLUDE = "include";
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";
    private final Deque<State> stack;
    private State state;
    int token;

    public XmlConfigurationReader(Reader reader, ConfigurationResourceResolver resolver, Properties properties, PropertyReplacer replacer, NamingStrategy namingStrategy) {
        this(reader, resolver, properties, replacer, namingStrategy, new ArrayDeque<State>());
    }

    private XmlConfigurationReader(Reader reader, ConfigurationResourceResolver resolver, Properties properties, PropertyReplacer replacer, NamingStrategy namingStrategy, Deque<State> stack) {
        super(resolver, properties, replacer, namingStrategy);
        this.state = new State(reader, this.getParser(reader), resolver);
        this.stack = stack;
        this.stack.push(this.state);
        this.token = -1;
    }

    private MXParser getParser(Reader reader) {
        MXParser parser = new MXParser(reader);
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return parser;
    }

    @Override
    public ConfigurationResourceResolver getResourceResolver() {
        return this.state.resolver;
    }

    @Override
    public void require(ConfigurationReader.ElementType elementType, String namespace, String name) {
        int type = switch (elementType) {
            case ConfigurationReader.ElementType.START_DOCUMENT -> 0;
            case ConfigurationReader.ElementType.END_DOCUMENT -> 1;
            case ConfigurationReader.ElementType.START_ELEMENT -> 2;
            case ConfigurationReader.ElementType.END_ELEMENT -> 3;
            default -> throw new IllegalArgumentException(elementType.name());
        };
        try {
            this.state.parser.require(type, namespace, name);
        }
        catch (IOException e) {
            throw new ConfigurationReaderException(e, this.getLocation());
        }
    }

    @Override
    public boolean hasNext() {
        if (this.token < 0) {
            try {
                this.token = this.state.parser.next();
                if (this.token == 1) {
                    this.token = this.closeInclude();
                }
            }
            catch (IOException e) {
                throw new ConfigurationReaderException(e, this.getLocation());
            }
        }
        return this.token != 1;
    }

    private int nextEvent() {
        try {
            int event;
            block5: {
                event = this.token < 0 ? this.state.parser.next() : this.token;
                this.token = -1;
                while (true) {
                    if (event == 2 && XINCLUDE.equals(this.getLocalName()) && XINCLUDE_NS.equals(this.getNamespace())) {
                        event = this.include();
                        continue;
                    }
                    if (event == 3 && XINCLUDE.equals(this.getLocalName()) && XINCLUDE_NS.equals(this.getNamespace())) {
                        event = this.closeInclude();
                        continue;
                    }
                    if (event != 1) break block5;
                    event = this.closeInclude();
                    if (event == 1) break;
                }
                return event;
            }
            return event;
        }
        catch (IOException | XmlPullParserException e) {
            throw new ConfigurationReaderException(e, this.getLocation());
        }
    }

    @Override
    public ConfigurationReader.ElementType nextElement() {
        int event = this.nextEvent();
        while (event == 4 || event == 7 || event == 8 || event == 9) {
            event = this.nextEvent();
        }
        return switch (event) {
            case 0 -> ConfigurationReader.ElementType.START_DOCUMENT;
            case 1 -> ConfigurationReader.ElementType.END_DOCUMENT;
            case 2 -> ConfigurationReader.ElementType.START_ELEMENT;
            case 3 -> ConfigurationReader.ElementType.END_ELEMENT;
            default -> throw new ConfigurationReaderException("Expecting event type >=1 <=4, got " + event, this.getLocation());
        };
    }

    @Override
    public String getLocalName(NamingStrategy strategy) {
        return strategy.convert(this.state.parser.getName());
    }

    @Override
    public String getNamespace() {
        return this.state.parser.getNamespace();
    }

    @Override
    public int getAttributeCount() {
        return this.state.parser.getAttributeCount();
    }

    @Override
    public String getAttributeName(int index, NamingStrategy strategy) {
        return strategy.convert(this.state.parser.getAttributeName(index));
    }

    @Override
    public String getAttributeValue(int index) {
        String value = this.state.parser.getAttributeValue(index);
        return this.replaceProperties(value);
    }

    @Override
    public String getAttributeValue(String localName, NamingStrategy strategy) {
        String value = this.state.parser.getAttributeValue(null, strategy.convert(localName));
        return this.replaceProperties(value);
    }

    @Override
    public String getElementText() {
        try {
            return this.replaceProperties(this.state.parser.nextText().trim());
        }
        catch (IOException e) {
            throw new ConfigurationReaderException("Expected text", this.getLocation());
        }
    }

    @Override
    public Location getLocation() {
        return new Location(this.getName(), this.state.parser.getLineNumber(), this.state.parser.getColumnNumber());
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.state.parser.getAttributeNamespace(index);
    }

    @Override
    public Map.Entry<String, String> getMapItem(String nameAttribute) {
        String type = this.getLocalName();
        String name = this.getAttributeValue(nameAttribute);
        return new SimpleImmutableEntry<String, String>(name, type);
    }

    @Override
    public void endMapItem() {
    }

    @Override
    public String[] readArray(String outer, String inner) {
        ArrayList<String> list = new ArrayList<String>();
        while (this.inTag(outer)) {
            if (inner.equals(this.getLocalName())) {
                list.add(this.getElementText());
                continue;
            }
            throw new ConfigurationReaderException(this.getLocalName(), this.getLocation());
        }
        return list.toArray(new String[0]);
    }

    private int include() {
        try {
            String href = this.getAttributeValue("href");
            URL url = this.state.resolver.resolveResource(href);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            this.state = new State(reader, this.getParser(reader), new URLConfigurationResourceResolver(url));
            this.stack.push(this.state);
            this.require(ConfigurationReader.ElementType.START_DOCUMENT);
            int tag = this.state.parser.nextTag();
            this.require(ConfigurationReader.ElementType.START_ELEMENT);
            return tag;
        }
        catch (IOException e) {
            throw new ConfigurationReaderException(e, this.getLocation());
        }
    }

    private int closeInclude() {
        try {
            if (this.stack.size() > 1) {
                State removed = this.stack.pop();
                Util.close((AutoCloseable)removed.reader);
                this.state = this.stack.peek();
                this.state.parser.nextTag();
                this.require(ConfigurationReader.ElementType.END_ELEMENT);
                return this.state.parser.nextTag();
            }
            return 1;
        }
        catch (IOException e) {
            throw new ConfigurationReaderException(e, this.getLocation());
        }
    }

    @Override
    public boolean hasFeature(ConfigurationFormatFeature feature) {
        switch (feature) {
            case MIXED_ELEMENTS: 
            case BARE_COLLECTIONS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        Util.close((AutoCloseable)this.state.reader);
    }

    @Override
    public void setAttributeValue(String namespace, String name, String value) {
    }

    private static final class State {
        Reader reader;
        XmlPullParser parser;
        ConfigurationResourceResolver resolver;

        State(Reader reader, MXParser parser, ConfigurationResourceResolver resolver) {
            this.reader = reader;
            this.parser = parser;
            this.resolver = resolver;
        }
    }
}

