/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.util.ArrayRingBuffer;
import org.junit.Assert;
import org.junit.Test;

public class ArrayRingBufferTest {
    @Test
    public void testShouldEnlargeItWithGaps() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        rb.set(1L, (Object)1);
        Assert.assertEquals((long)rb.size(), (long)1L);
        Assert.assertEquals((Object)rb.get(1L), (Object)1);
        rb.set(3L, (Object)2);
        Assert.assertEquals((long)rb.size(), (long)3L);
        Assert.assertEquals((Object)rb.get(1L), (Object)1);
        Assert.assertNull((Object)rb.get(2L));
        Assert.assertEquals((Object)rb.get(3L), (Object)2);
    }

    @Test
    public void testShouldEnlargeItWithTwiceWrap() {
        int i;
        ArrayRingBuffer rb = new ArrayRingBuffer(6);
        for (i = 6; i < 10; ++i) {
            rb.set((long)i, (Object)i);
        }
        Assert.assertEquals((long)rb.availableCapacityWithoutResizing(), (long)4L);
        rb.set(10L, (Object)10);
        Assert.assertEquals((long)rb.availableCapacityWithoutResizing(), (long)3L);
        for (i = 6; i < 11; ++i) {
            Assert.assertEquals((Object)rb.get((long)i), (Object)i);
        }
    }

    @Test
    public void testForEach() {
        ArrayRingBuffer rb = new ArrayRingBuffer(6);
        for (int i = 6; i <= 10; ++i) {
            rb.set((long)i, (Object)i);
        }
        HashMap expected_values = new HashMap(5);
        rb.forEach(expected_values::put);
        Assert.assertEquals((long)expected_values.size(), (long)5L);
        for (Map.Entry e : expected_values.entrySet()) {
            Integer key = (Integer)e.getKey();
            Long val = (Long)e.getValue();
            Assert.assertEquals((long)key.intValue(), (long)val.intValue());
        }
    }

    @Test
    public void testRemove() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        for (int i = 1; i <= 10; ++i) {
            rb.set((long)i, (Object)i);
        }
        Assert.assertEquals((long)rb.size(), (long)10L);
        Assert.assertEquals((long)rb.size(false), (long)10L);
        Integer ret = (Integer)rb.remove(0L);
        Assert.assertNull((Object)ret);
        ret = (Integer)rb.remove(1L);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)ret.intValue(), (long)1L);
        Assert.assertEquals((long)rb.size(), (long)9L);
        Assert.assertEquals((long)rb.size(false), (long)9L);
        ret = (Integer)rb.remove(5L);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)ret.intValue(), (long)5L);
        Assert.assertEquals((String)String.format("size should be 8 but is %d", rb.size(false)), (long)rb.size(false), (long)8L);
        rb.set(5L, (Object)5);
        Assert.assertEquals((long)rb.size(false), (long)9L);
    }

    @Test
    public void testShouldUseAvailableCapacity() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        rb.set(1L, (Object)1);
        rb.set(7L, (Object)2);
        Assert.assertEquals((long)rb.size(), (long)7L);
        rb.set(8L, (Object)3);
        Assert.assertEquals((Object)rb.get(1L), (Object)1);
        Assert.assertEquals((Object)rb.get(7L), (Object)2);
        Assert.assertEquals((Object)rb.get(8L), (Object)3);
    }

    @Test
    public void testShouldCopyOldElementsInTheRightOrder() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        rb.set(1L, (Object)1);
        rb.set(7L, (Object)2);
        rb.set(8L, (Object)3);
        rb.set(15L, (Object)4);
        Assert.assertEquals((Object)rb.get(1L), (Object)1);
        Assert.assertEquals((Object)rb.get(7L), (Object)2);
        Assert.assertEquals((Object)rb.get(8L), (Object)3);
        Assert.assertEquals((Object)rb.get(15L), (Object)4);
    }

    @Test
    public void testShouldClearAndIncreaseAvailableSpace() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        rb.set(1L, (Object)1);
        rb.set(7L, (Object)2);
        rb.set(8L, (Object)3);
        int before = rb.availableCapacityWithoutResizing();
        rb.dropHeadUntil(5L);
        int after = rb.availableCapacityWithoutResizing();
        Assert.assertEquals((long)(after - before), (long)6L);
        Assert.assertEquals((Object)rb.get(7L), (Object)2);
        Assert.assertEquals((Object)rb.get(8L), (Object)3);
        rb.set(12L, (Object)4);
        Assert.assertEquals((long)rb.availableCapacityWithoutResizing(), (long)2L);
        Assert.assertEquals((Object)rb.get(12L), (Object)4);
    }

    @Test
    public void testShouldEnlargeCapacityByPowerOfTwo() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        rb.set(1L, (Object)1);
        rb.set(4L, (Object)2);
        rb.set(7L, (Object)3);
        rb.set(8L, (Object)4);
        rb.dropHeadUntil(5L);
        rb.set(14L, (Object)5);
        Assert.assertEquals((long)rb.availableCapacityWithoutResizing(), (long)0L);
    }

    @Test
    public void testShouldClearUptoAlthoughWrapped() {
        ArrayRingBuffer rb = new ArrayRingBuffer(4);
        for (int i = 4; i < 12; ++i) {
            rb.set((long)i, (Object)i);
        }
        rb.dropHeadUntil(11L);
        Assert.assertEquals((long)rb.size(), (long)1L);
        Assert.assertEquals((Object)rb.get(11L), (Object)11);
    }

    @Test
    public void testShouldClearFromAlthoughWrapped() {
        ArrayRingBuffer rb = new ArrayRingBuffer(4);
        for (int i = 4; i < 12; ++i) {
            rb.set((long)i, (Object)i);
        }
        rb.dropTailTo(7L);
        Assert.assertEquals((long)rb.size(), (long)3L);
        Assert.assertEquals((long)rb.size(false), (long)3L);
        Assert.assertEquals((Object)rb.get(4L), (Object)4);
        Assert.assertEquals((Object)rb.get(5L), (Object)5);
        Assert.assertEquals((Object)rb.get(6L), (Object)6);
    }

    @Test
    public void testShouldClearUpToAllWrapped() {
        ArrayRingBuffer rb = new ArrayRingBuffer(4);
        for (int i = 4; i < 12; ++i) {
            rb.set((long)i, (Object)i);
        }
        rb.clear();
        Assert.assertEquals((long)rb.size(), (long)0L);
    }

    @Test
    public void testShouldClearFromAllWrapped() {
        ArrayRingBuffer rb = new ArrayRingBuffer(4);
        for (int i = 4; i < 12; ++i) {
            rb.set((long)i, (Object)i);
        }
        rb.dropTailTo(rb.getHeadSequence());
        Assert.assertEquals((long)rb.size(), (long)0L);
    }

    @Test
    public void testDropTailTo() {
        int i;
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        for (i = 1; i <= 20; ++i) {
            rb.set((long)i, (Object)i);
        }
        Assert.assertEquals((long)rb.size(), (long)20L);
        for (i = 1; i <= 20; ++i) {
            Assert.assertEquals((long)((Integer)rb.get((long)i)).intValue(), (long)i);
        }
        rb.dropTailTo(5L);
        Assert.assertEquals((long)rb.size(), (long)4L);
        try {
            Assert.assertEquals((long)((Integer)rb.get(5L)).intValue(), (long)0L);
            Assert.fail((String)"index 5 should not be found");
        }
        catch (IllegalArgumentException t) {
            System.out.println("get(5) triggered an exception, as expected");
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            Assert.assertEquals((long)((Integer)rb.get((long)i2)).intValue(), (long)i2);
        }
    }

    @Test
    public void testDropHeadUntil() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        for (int i = 1; i <= 20; ++i) {
            rb.set((long)i, (Object)i);
        }
        Assert.assertEquals((long)rb.size(), (long)20L);
        rb.dropHeadUntil(6L);
        Assert.assertEquals((long)rb.size(), (long)15L);
        try {
            rb.get(5L);
            Assert.fail((String)"index 5 should not be found");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("get(5) triggered an exception, as expected");
        }
        for (int i = 6; i <= 20; ++i) {
            Assert.assertEquals((long)((Integer)rb.get((long)i)).intValue(), (long)i);
        }
    }

    @Test
    public void testCannotAccessClearedUpData() {
        ArrayRingBuffer rb = new ArrayRingBuffer(1);
        rb.set(1L, (Object)1);
        rb.set(5L, (Object)3);
        rb.set(15L, (Object)4);
        rb.dropHeadUntil(5L);
        Assert.assertThrows(IllegalArgumentException.class, () -> rb.get(4L));
    }

    @Test
    public void testCreatingBackedArrayOfSpecificSize() {
        Assert.assertEquals((long)new ArrayRingBuffer(8, 0L).availableCapacityWithoutResizing(), (long)8L);
    }

    @Test
    public void testAddPeekPollIsEmptySizeConsistency() {
        int i;
        int initialHead = 10;
        int size = 10;
        ArrayRingBuffer rb = new ArrayRingBuffer(10, 10L);
        for (i = 0; i < 10; ++i) {
            rb.add((Object)i);
        }
        Assert.assertEquals((long)rb.size(), (long)10L);
        for (i = 0; i < 10; ++i) {
            Integer expected = i;
            Assert.assertEquals((Object)rb.peek(), (Object)expected);
            Assert.assertEquals((Object)rb.poll(), (Object)expected);
            Assert.assertEquals((long)rb.size(), (long)(10 - (i + 1)));
            Assert.assertEquals((long)rb.getHeadSequence(), (long)(10 + i + 1));
        }
        Assert.assertTrue((boolean)rb.isEmpty());
        Assert.assertNull((Object)rb.peek());
        Assert.assertNull((Object)rb.poll());
        Assert.assertEquals((long)rb.size(), (long)0L);
    }
}

