/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolvers;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.configuration.io.xml.XmlConfigurationReader;
import org.infinispan.commons.configuration.io.yaml.YamlConfigurationReaderTest;
import org.junit.Assert;
import org.junit.Test;

public class XmlConfigurationReaderTest {
    @Test
    public void testEscapes() {
        StringReader sr = new StringReader("<e1 a1=\"v&#34;1&#34;\" a2=\"&#60;v2>\" a3=\"&quot;\"/>\n");
        try (XmlConfigurationReader r = new XmlConfigurationReader((Reader)sr, ConfigurationResourceResolvers.DEFAULT, new Properties(), PropertyReplacer.DEFAULT, NamingStrategy.CAMEL_CASE);){
            r.require(ConfigurationReader.ElementType.START_DOCUMENT);
            r.nextElement();
            r.require(ConfigurationReader.ElementType.START_ELEMENT, "", "e1");
            Assert.assertEquals((long)3L, (long)r.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)r, "a1", "v\"1\"");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)r, "a2", "<v2>");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)r, "a3", "\"");
            r.nextElement();
            r.require(ConfigurationReader.ElementType.END_ELEMENT);
            r.nextElement();
            r.require(ConfigurationReader.ElementType.END_DOCUMENT);
        }
    }
}

