/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.nio.charset.StandardCharsets;
import org.infinispan.commons.util.ByRef;

public final class GlobMatcher {
    private GlobMatcher() {
    }

    public static boolean match(String pattern, String string) {
        GlobMatcher.assertSingleByte(string);
        return GlobMatcher.match(pattern.getBytes(StandardCharsets.US_ASCII), string.getBytes(StandardCharsets.US_ASCII));
    }

    public static boolean match(byte[] pattern, byte[] string) {
        GlobMatcher.assertSingleByte(string);
        ByRef.Boolean skipLongerMatches = new ByRef.Boolean(false);
        return GlobMatcher.match(pattern, 0, string, 0, skipLongerMatches);
    }

    private static boolean match(byte[] pattern, int patternPos, byte[] string, int stringPos, ByRef.Boolean skipLongerMatches) {
        while (patternPos < pattern.length && stringPos < string.length) {
            switch (pattern[patternPos]) {
                case 42: {
                    while (patternPos < pattern.length - 1 && pattern[patternPos + 1] == 42) {
                        ++patternPos;
                    }
                    if (patternPos == pattern.length) {
                        return true;
                    }
                    while (stringPos <= string.length) {
                        if (GlobMatcher.match(pattern, patternPos + 1, string, stringPos, skipLongerMatches)) {
                            return true;
                        }
                        if (skipLongerMatches.get()) {
                            return false;
                        }
                        ++stringPos;
                    }
                    skipLongerMatches.set(true);
                    return false;
                }
                case 63: {
                    ++stringPos;
                    break;
                }
                case 91: {
                    boolean notOp;
                    boolean bl = notOp = pattern[++patternPos] == 94;
                    if (notOp) {
                        ++patternPos;
                    }
                    boolean match = false;
                    while (true) {
                        if (patternPos == pattern.length) {
                            --patternPos;
                            break;
                        }
                        if (patternPos < pattern.length - 1 && pattern[patternPos] == 92) {
                            if (pattern[++patternPos] == string[stringPos]) {
                                match = true;
                            }
                        } else {
                            if (pattern[patternPos] == 93) break;
                            if (patternPos < pattern.length - 2 && pattern[patternPos + 1] == 45) {
                                byte start = pattern[patternPos];
                                byte end = pattern[patternPos + 2];
                                byte c = string[stringPos];
                                if (start > end) {
                                    byte t = start;
                                    start = end;
                                    end = t;
                                }
                                patternPos += 2;
                                if (c >= start && c <= end) {
                                    match = true;
                                }
                            } else {
                                match |= pattern[patternPos] == string[stringPos];
                            }
                        }
                        ++patternPos;
                    }
                    if (notOp) {
                        boolean bl2 = match = !match;
                    }
                    if (!match) {
                        return false;
                    }
                    ++stringPos;
                    break;
                }
                case 92: {
                    if (patternPos < pattern.length - 1) {
                        ++patternPos;
                    }
                }
                default: {
                    if (pattern[patternPos] != string[stringPos]) {
                        return false;
                    }
                    ++stringPos;
                }
            }
            ++patternPos;
            if (stringPos != string.length) continue;
            while (patternPos < pattern.length && pattern[patternPos] == 42) {
                ++patternPos;
            }
            break block6;
        }
        return patternPos == pattern.length && stringPos == string.length;
    }

    private static void assertSingleByte(String s) {
        byte[] bytes = s.getBytes();
        GlobMatcher.assertSingleByte(bytes);
    }

    private static void assertSingleByte(byte[] bytes) {
        for (byte b : bytes) {
            assert ((b & 0x80) == 0) : "Multi-byte character not accepted";
        }
    }
}

