/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.commons.util.GlobMatcher;
import org.junit.Assert;
import org.junit.Test;

public class GlobMatcherTest {
    @Test
    public void testFuzzMatcher() {
        byte[] str = new byte[32];
        byte[] pat = new byte[32];
        int cycles = 10000000;
        while (cycles-- > 0) {
            ThreadLocalRandom.current().nextBytes(str);
            this.nextBytes(pat);
            GlobMatcher.match((byte[])str, (byte[])pat);
        }
    }

    private void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int rnd = ThreadLocalRandom.current().nextInt(128);
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
            }
        }
    }

    @Test
    public void testMultiByteString() {
        Assert.assertThrows(AssertionError.class, () -> GlobMatcher.match((String)"p?tte*n", (String)"Jos\u00e9"));
        Assert.assertThrows(AssertionError.class, () -> GlobMatcher.match((byte[])"p?tte*n".getBytes(StandardCharsets.US_ASCII), (byte[])"Jos\u00e9".getBytes()));
        Assert.assertThrows(AssertionError.class, () -> GlobMatcher.match((String)"p?tte*n", (String)"\u20ac10,00"));
        Assert.assertThrows(AssertionError.class, () -> GlobMatcher.match((byte[])"p?tte*n".getBytes(StandardCharsets.US_ASCII), (byte[])"\u20ac10,00".getBytes()));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"Jo?*", (String)"Jose"));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"$[1-9]*,[0-9][0-9]", (String)"$101,23"));
        Assert.assertTrue((boolean)GlobMatcher.match((byte[])"$[1-9]*,[0-9][0-9]".getBytes(StandardCharsets.US_ASCII), (byte[])"$101,23".getBytes(StandardCharsets.US_ASCII)));
    }

    @Test
    public void testValidInputs() {
        Assert.assertFalse((boolean)GlobMatcher.match((String)"a*b", (String)"aaa"));
        Assert.assertFalse((boolean)GlobMatcher.match((String)"a*a*b", (String)"aaaa"));
        Assert.assertFalse((boolean)GlobMatcher.match((String)"a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*b", (String)"a".repeat(55)));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"a*a*b", (String)"aaa7b"));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"a*[0-9]b", (String)"aH5b"));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"a*[k\\-0-9]b", (String)"aHk5b"));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"a*[k\\-0-9]b", (String)"aH-5b"));
        Assert.assertFalse((boolean)GlobMatcher.match((String)"a*[k\\-0-9]b", (String)"aHb"));
        Assert.assertFalse((boolean)GlobMatcher.match((String)"a*[0-9]b", (String)"aHRb"));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*b", (String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"hello_[24]", (String)"hello_4"));
        Assert.assertTrue((boolean)GlobMatcher.match((String)"hello_[24]", (String)"hello_2"));
    }

    @Test
    public void testValidInputBytes() {
        Assert.assertFalse((boolean)GlobMatcher.match((byte[])new byte[]{97, 42, 98}, (byte[])new byte[]{97, 97, 97}));
        Assert.assertTrue((boolean)GlobMatcher.match((byte[])new byte[]{97, 42, 98}, (byte[])new byte[]{97, 97, 97, 98}));
        Assert.assertTrue((boolean)GlobMatcher.match((byte[])new byte[]{97, 42, 91, 48, 45, 57, 93, 98}, (byte[])new byte[]{97, 72, 53, 98}));
    }
}

