/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=12)
@SerializeWith(value=MediaTypeExternalizer.class)
public final class MediaType {
    public static final String APPLICATION_OPENMETRICS_TYPE = "application/openmetrics-text";
    public static final String APPLICATION_JAVASCRIPT_TYPE = "application/javascript";
    public static final String APPLICATION_JSON_TYPE = "application/json";
    public static final String APPLICATION_OCTET_STREAM_TYPE = "application/octet-stream";
    public static final String APPLICATION_OBJECT_TYPE = "application/x-java-object";
    public static final String APPLICATION_PDF_TYPE = "application/pdf";
    public static final String APPLICATION_RTF_TYPE = "application/rtf";
    public static final String APPLICATION_SERIALIZED_OBJECT_TYPE = "application/x-java-serialized-object";
    public static final String APPLICATION_XML_TYPE = "application/xml";
    public static final String APPLICATION_ZIP_TYPE = "application/zip";
    public static final String APPLICATION_JBOSS_MARSHALLING_TYPE = "application/x-jboss-marshalling";
    public static final String APPLICATION_PROTOSTREAM_TYPE = "application/x-protostream";
    @Deprecated
    public static final String APPLICATION_UNKNOWN_TYPE = "application/unknown";
    public static final String WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    public static final String IMAGE_GIF_TYPE = "image/gif";
    public static final String IMAGE_JPEG_TYPE = "image/jpeg";
    public static final String IMAGE_PNG_TYPE = "image/png";
    public static final String MULTIPART_FORM_DATA_TYPE = "multipart/form-data";
    public static final String TEXT_CSS_TYPE = "text/css";
    public static final String TEXT_CSV_TYPE = "text/csv";
    public static final String TEXT_PLAIN_TYPE = "text/plain";
    public static final String TEXT_HTML_TYPE = "text/html";
    @Deprecated
    public static final String APPLICATION_INFINISPAN_MARSHALLING_TYPE = "application/x-infinispan-marshalling";
    @Deprecated
    public static final String APPLICATION_INFINISPAN_BINARY_TYPE = "application/x-infinispan-binary";
    public static final String APPLICATION_PROTOSTUFF_TYPE = "application/x-protostuff";
    public static final String APPLICATION_KRYO_TYPE = "application/x-kryo";
    public static final String MATCH_ALL_TYPE = "*/*";
    public static final MediaType APPLICATION_OPENMETRICS = MediaType.fromString("application/openmetrics-text");
    public static final MediaType APPLICATION_JAVASCRIPT = MediaType.fromString("application/javascript");
    public static final MediaType APPLICATION_JSON = MediaType.fromString("application/json");
    public static final MediaType APPLICATION_OCTET_STREAM = MediaType.fromString("application/octet-stream");
    public static final MediaType APPLICATION_OBJECT = MediaType.fromString("application/x-java-object");
    public static final MediaType APPLICATION_SERIALIZED_OBJECT = MediaType.fromString("application/x-java-serialized-object");
    public static final MediaType APPLICATION_XML = MediaType.fromString("application/xml");
    public static final MediaType APPLICATION_PROTOSTREAM = MediaType.fromString("application/x-protostream");
    public static final MediaType APPLICATION_JBOSS_MARSHALLING = MediaType.fromString("application/x-jboss-marshalling");
    @Deprecated
    public static final MediaType APPLICATION_INFINISPAN_MARSHALLED = MediaType.fromString("application/x-infinispan-marshalling");
    public static final MediaType APPLICATION_WWW_FORM_URLENCODED = MediaType.fromString("application/x-www-form-urlencoded");
    public static final MediaType IMAGE_PNG = MediaType.fromString("image/png");
    public static final MediaType MULTIPART_FORM_DATA = MediaType.fromString("multipart/form-data");
    public static final MediaType TEXT_PLAIN = MediaType.fromString("text/plain");
    public static final MediaType TEXT_CSS = MediaType.fromString("text/css");
    public static final MediaType TEXT_CSV = MediaType.fromString("text/csv");
    public static final MediaType TEXT_HTML = MediaType.fromString("text/html");
    public static final MediaType IMAGE_GIF = MediaType.fromString("image/gif");
    public static final MediaType IMAGE_JPEG = MediaType.fromString("image/jpeg");
    public static final MediaType APPLICATION_PROTOSTUFF = MediaType.fromString("application/x-protostuff");
    public static final MediaType APPLICATION_KRYO = MediaType.fromString("application/x-kryo");
    @Deprecated
    public static final MediaType APPLICATION_INFINISPAN_BINARY = MediaType.fromString("application/x-infinispan-binary");
    public static final MediaType APPLICATION_PDF = MediaType.fromString("application/pdf");
    public static final MediaType APPLICATION_RTF = MediaType.fromString("application/rtf");
    public static final MediaType APPLICATION_ZIP = MediaType.fromString("application/zip");
    @Deprecated
    public static final MediaType APPLICATION_INFINISPAN_MARSHALLING = MediaType.fromString("application/x-infinispan-marshalling");
    @Deprecated
    public static final MediaType APPLICATION_UNKNOWN = MediaType.fromString("application/unknown");
    public static final MediaType MATCH_ALL = MediaType.fromString("*/*");
    public static final String BYTE_ARRAY_TYPE = "ByteArray";
    private static final String INVALID_TOKENS = "()<>@,;:/[]?=\\\"";
    private static final String WEIGHT_PARAM_NAME = "q";
    private static final String CHARSET_PARAM_NAME = "charset";
    private static final String CLASS_TYPE_PARAM_NAME = "type";
    private static final double DEFAULT_WEIGHT = 1.0;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Map<String, String> params = new HashMap<String, String>(2);
    private final String type;
    private final String subType;
    private final String typeSubtype;
    private final transient double weight;

    public MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Map<String, String> params) {
        this.type = MediaType.validate(type);
        this.subType = MediaType.validate(subtype);
        this.typeSubtype = type + "/" + subtype;
        if (params != null) {
            this.params.putAll(params);
            String weight = params.get(WEIGHT_PARAM_NAME);
            this.weight = weight != null ? MediaType.parseWeight(weight) : 1.0;
        } else {
            this.weight = 1.0;
        }
    }

    @ProtoField(number=1)
    String getTree() {
        return this.toString();
    }

    @Deprecated
    public static MediaType parse(String str) {
        return MediaType.fromString(str);
    }

    @ProtoFactory
    public static MediaType fromString(String tree) {
        if (tree == null || tree.isEmpty()) {
            throw Log.CONTAINER.missingMediaType();
        }
        int separatorIdx = tree.indexOf(59);
        boolean emptyParams = separatorIdx == -1;
        String types = emptyParams ? tree : tree.substring(0, separatorIdx);
        String params = emptyParams ? "" : tree.substring(separatorIdx + 1);
        Map<String, String> paramMap = MediaType.parseParams(params);
        if (types.trim().equals("*")) {
            return emptyParams ? MATCH_ALL : new MediaType("*", "*", paramMap);
        }
        if (types.indexOf(47) == -1) {
            throw Log.CONTAINER.invalidMediaTypeSubtype();
        }
        String[] typeSubtype = types.split("/");
        if (typeSubtype.length > 2) {
            throw Log.CONTAINER.invalidMediaTypeSubtype();
        }
        return new MediaType(typeSubtype[0].trim(), typeSubtype[1].trim(), paramMap);
    }

    public static Stream<MediaType> parseList(String mediaTypeList) {
        return Arrays.stream(mediaTypeList.split(",")).map(MediaType::fromString).sorted(Comparator.comparingDouble(m -> m.weight).reversed());
    }

    private static double parseWeight(String weightValue) {
        try {
            return Double.parseDouble(weightValue);
        }
        catch (NumberFormatException nf) {
            throw Log.CONTAINER.invalidWeight(weightValue);
        }
    }

    private static Map<String, String> parseParams(String params) {
        String[] parameters;
        HashMap<String, String> parsed = new HashMap<String, String>();
        if (params == null || params.isEmpty()) {
            return parsed;
        }
        for (String p : parameters = params.split(";")) {
            if (!p.contains("=")) {
                throw Log.CONTAINER.invalidMediaTypeParam(p);
            }
            String[] nameValue = p.split("=");
            String paramName = nameValue[0].trim();
            String paramValue = nameValue[1].trim();
            boolean isQuoted = paramValue.startsWith("\"") || paramValue.startsWith("'");
            String parsedValue = paramValue;
            if (isQuoted) {
                MediaType.checkValidQuotes(paramValue);
                String quoted = nameValue[1].trim();
                parsedValue = quoted.substring(1, quoted.length() - 1);
            }
            parsed.put(MediaType.validate(paramName), MediaType.validate(parsedValue));
        }
        return parsed;
    }

    private static boolean checkStartAndEnd(String toCheck, char c) {
        return toCheck != null && toCheck.charAt(0) == c && toCheck.charAt(toCheck.length() - 1) == c;
    }

    private static void checkValidQuotes(String paramValue) {
        if (!MediaType.checkStartAndEnd(paramValue, '\'') && !MediaType.checkStartAndEnd(paramValue, '\"')) {
            throw Log.CONTAINER.unquotedMediaTypeParam();
        }
    }

    public boolean match(MediaType other) {
        return other != null && (other.matchesAll() || this.matchesAll() || other.typeSubtype.equals(this.typeSubtype));
    }

    public boolean matchesAll() {
        return this.typeSubtype.equals(MATCH_ALL_TYPE);
    }

    public String getTypeSubtype() {
        return this.typeSubtype;
    }

    public MediaType withoutParameters() {
        if (this.params.isEmpty()) {
            return this;
        }
        return new MediaType(this.type, this.subType);
    }

    public double getWeight() {
        return this.weight;
    }

    public Charset getCharset() {
        return this.getParameter(CHARSET_PARAM_NAME).map(Charset::forName).orElse(DEFAULT_CHARSET);
    }

    public String getClassType() {
        return this.getParameter(CLASS_TYPE_PARAM_NAME).orElse(null);
    }

    public MediaType withClassType(Class<?> clazz) {
        return this.withParameter(CLASS_TYPE_PARAM_NAME, clazz.getName());
    }

    public boolean hasStringType() {
        String classType = this.getClassType();
        return classType != null && classType.equals(String.class.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.params.equals(mediaType.params) && this.typeSubtype.equals(mediaType.typeSubtype);
    }

    public int hashCode() {
        int result = this.params.hashCode();
        result = 31 * result + this.typeSubtype.hashCode();
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean hasParameters() {
        return !this.params.isEmpty();
    }

    public Optional<String> getParameter(String name) {
        return Optional.ofNullable(this.params.get(name));
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public MediaType withParameters(Map<String, String> parameters) {
        return parameters.isEmpty() ? this : new MediaType(this.type, this.subType, parameters);
    }

    private static String validate(String token) {
        if (token == null) {
            throw new NullPointerException("type and subtype cannot be null");
        }
        for (char c : token.toCharArray()) {
            if (c >= ' ' && c <= '\u007f' && INVALID_TOKENS.indexOf(c) <= 0) continue;
            throw Log.CONTAINER.invalidCharMediaType(c, token);
        }
        return token;
    }

    public MediaType withCharset(Charset charset) {
        return this.withParameter(CHARSET_PARAM_NAME, charset.toString());
    }

    public MediaType withParameter(String name, String value) {
        HashMap<String, String> newParams = new HashMap<String, String>(this.params);
        newParams.put(name, value);
        return new MediaType(this.type, this.subType, newParams);
    }

    public String toStringExcludingParam(String ... params) {
        if (!this.hasParameters()) {
            return this.typeSubtype;
        }
        StringBuilder builder = new StringBuilder().append(this.typeSubtype);
        String strParams = this.params.entrySet().stream().filter(e -> Arrays.stream(params).noneMatch(p -> p.equals(e.getKey()))).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("; "));
        if (strParams.isEmpty()) {
            return builder.toString();
        }
        return builder.append("; ").append(strParams).toString();
    }

    public boolean isBinary() {
        String customType = this.getClassType();
        if (customType == null) {
            return !this.match(APPLICATION_OBJECT);
        }
        return BYTE_ARRAY_TYPE.equals(customType);
    }

    public String toString() {
        return this.toStringExcludingParam(WEIGHT_PARAM_NAME);
    }

    public static final class MediaTypeExternalizer
    implements Externalizer<MediaType> {
        @Override
        public void writeObject(ObjectOutput output, MediaType mediaType) throws IOException {
            Short id = MediaTypeIds.getId(mediaType);
            if (id == null) {
                output.writeBoolean(false);
                output.writeUTF(mediaType.type);
                output.writeUTF(mediaType.subType);
                output.writeObject(mediaType.params);
            } else {
                output.writeBoolean(true);
                output.writeShort(id.shortValue());
                output.writeObject(mediaType.params);
            }
        }

        @Override
        public MediaType readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean isInternal = input.readBoolean();
            if (isInternal) {
                short id = input.readShort();
                Map params = (Map)input.readObject();
                return MediaTypeIds.getMediaType(id).withParameters(params);
            }
            String type = input.readUTF();
            String subType = input.readUTF();
            Map params = (Map)input.readObject();
            return new MediaType(type, subType, params);
        }
    }
}

