/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.SecurityActions;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

@Deprecated
public final class JmxUtil {
    private static final Log log = LogFactory.getLog(JmxUtil.class);

    public static String buildJmxDomain(String jmxDomain, MBeanServer mBeanServer, String groupName) {
        if (jmxDomain == null) {
            throw new IllegalArgumentException("jmxDomain cannot be null");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("groupName cannot be null");
        }
        String finalName = jmxDomain;
        int index = 2;
        try {
            while (!SecurityActions.queryNames(new ObjectName(finalName + ':' + groupName + ",*"), null, mBeanServer).isEmpty()) {
                finalName = jmxDomain + index++;
            }
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Failed to check for duplicate JMX domain names", e);
        }
        return finalName;
    }

    public static void registerMBean(Object mBeanInstance, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        try {
            SecurityActions.registerMBean(mBeanInstance, objectName, mBeanServer);
            if (log.isTraceEnabled()) {
                log.tracef("Registered MBean %s under %s", mBeanInstance, objectName);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            log.couldNotRegisterObjectName(objectName, e);
            throw e;
        }
    }

    public static void unregisterMBean(ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        if (mBeanServer.isRegistered(objectName)) {
            SecurityActions.unregisterMBean(objectName, mBeanServer);
            if (log.isTraceEnabled()) {
                log.tracef("Unregistered MBean: %s", objectName);
            }
        } else {
            log.debugf("MBean not registered: %s", objectName);
        }
    }
}

