/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Util;

@Immutable
public class MarshallUtil {
    private static final byte NULL_VALUE = -1;
    private static final Log log = LogFactory.getLog(MarshallUtil.class);

    public static byte[] toByteArray(ByteBuffer buf) {
        if (buf.getOffset() == 0 && buf.getLength() == buf.getBuf().length) {
            return buf.getBuf();
        }
        byte[] bytes = new byte[buf.getLength()];
        System.arraycopy(buf.getBuf(), buf.getOffset(), bytes, 0, buf.getLength());
        return bytes;
    }

    public static <K, V, T extends Map<K, V>> void marshallMap(T map, ObjectOutput out) throws IOException {
        int mapSize = map == null ? -1 : map.size();
        MarshallUtil.marshallSize(out, mapSize);
        if (mapSize <= 0) {
            return;
        }
        for (Map.Entry<K, V> me : map.entrySet()) {
            out.writeObject(me.getKey());
            out.writeObject(me.getValue());
        }
    }

    public static <K, V, T extends Map<K, V>> T unmarshallMap(ObjectInput in, MapBuilder<K, V, T> builder) throws IOException, ClassNotFoundException {
        int size = MarshallUtil.unmarshallSize(in);
        if (size == -1) {
            return null;
        }
        T map = Objects.requireNonNull(builder, "MapBuilder must be non-null").build(CollectionFactory.computeCapacity(size));
        for (int i = 0; i < size; ++i) {
            map.put((Object)in.readObject(), (Object)in.readObject());
        }
        return map;
    }

    public static <K, V, T extends Map<K, V>> void marshallMap(T map, ElementWriter<K> keyWriter, ElementWriter<V> valueWrite, ObjectOutput out) throws IOException {
        int mapSize = map == null ? -1 : map.size();
        MarshallUtil.marshallSize(out, mapSize);
        if (mapSize <= 0) {
            return;
        }
        for (Map.Entry<K, V> me : map.entrySet()) {
            keyWriter.writeTo(out, me.getKey());
            valueWrite.writeTo(out, me.getValue());
        }
    }

    public static <K, V, T extends Map<K, V>> T unmarshallMap(ObjectInput in, ElementReader<K> keyReader, ElementReader<V> valueReader, MapBuilder<K, V, T> builder) throws IOException, ClassNotFoundException {
        int size = MarshallUtil.unmarshallSize(in);
        if (size == -1) {
            return null;
        }
        T map = Objects.requireNonNull(builder, "MapBuilder must be non-null").build(CollectionFactory.computeCapacity(size));
        for (int i = 0; i < size; ++i) {
            map.put(keyReader.readFrom(in), valueReader.readFrom(in));
        }
        return map;
    }

    public static void marshallUUID(UUID uuid, ObjectOutput out, boolean checkNull) throws IOException {
        if (checkNull) {
            if (uuid == null) {
                out.writeBoolean(true);
                return;
            }
            out.writeBoolean(false);
        }
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID unmarshallUUID(ObjectInput in, boolean checkNull) throws IOException {
        if (checkNull && in.readBoolean()) {
            return null;
        }
        return new UUID(in.readLong(), in.readLong());
    }

    public static <E> void marshallArray(E[] array, ObjectOutput out) throws IOException {
        int size = array == null ? -1 : array.length;
        MarshallUtil.marshallSize(out, size);
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            out.writeObject(array[i]);
        }
    }

    public static <E> E[] unmarshallArray(ObjectInput in, ArrayBuilder<E> builder) throws IOException, ClassNotFoundException {
        int size = MarshallUtil.unmarshallSize(in);
        if (size == -1) {
            return null;
        }
        E[] array = Objects.requireNonNull(builder, "ArrayBuilder must be non-null").build(size);
        for (int i = 0; i < size; ++i) {
            array[i] = in.readObject();
        }
        return array;
    }

    public static <E> void marshallCollection(Collection<E> collection, ObjectOutput out) throws IOException {
        MarshallUtil.marshallCollection(collection, out, ObjectOutput::writeObject);
    }

    public static <E> void marshallCollection(Collection<E> collection, ObjectOutput out, ElementWriter<E> writer) throws IOException {
        int size = collection == null ? -1 : collection.size();
        MarshallUtil.marshallSize(out, size);
        if (size <= 0) {
            return;
        }
        for (E e : collection) {
            writer.writeTo(out, e);
        }
    }

    public static <E, T extends Collection<E>> T unmarshallCollection(ObjectInput in, CollectionBuilder<E, T> builder, ElementReader<E> reader) throws IOException, ClassNotFoundException {
        int size = MarshallUtil.unmarshallSize(in);
        if (size == -1) {
            return null;
        }
        T collection = Objects.requireNonNull(builder, "CollectionBuilder must be non-null").build(size);
        for (int i = 0; i < size; ++i) {
            collection.add(reader.readFrom(in));
        }
        return collection;
    }

    public static <E, T extends Collection<E>> T unmarshallCollection(ObjectInput in, CollectionBuilder<E, T> builder) throws IOException, ClassNotFoundException {
        return MarshallUtil.unmarshallCollection(in, builder, input -> input.readObject());
    }

    public static <E, T extends Collection<E>> T unmarshallCollectionUnbounded(ObjectInput in, UnboundedCollectionBuilder<E, T> builder) throws IOException, ClassNotFoundException {
        int size = MarshallUtil.unmarshallSize(in);
        if (size == -1) {
            return null;
        }
        T collection = Objects.requireNonNull(builder, "UnboundedCollectionBuilder must be non-null").build();
        for (int i = 0; i < size; ++i) {
            collection.add((Object)in.readObject());
        }
        return collection;
    }

    public static void marshallString(String string, ObjectOutput out) throws IOException {
        if (string == null) {
            out.writeBoolean(true);
            return;
        }
        out.writeBoolean(false);
        out.writeUTF(string);
    }

    public static String unmarshallString(ObjectInput in) throws IOException {
        if (in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    public static void marshallByteArray(byte[] array, ObjectOutput out) throws IOException {
        int size = array == null ? -1 : array.length;
        MarshallUtil.marshallSize(out, size);
        if (size <= 0) {
            return;
        }
        out.write(array);
    }

    public static byte[] unmarshallByteArray(ObjectInput in) throws IOException {
        int size = MarshallUtil.unmarshallSize(in);
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[size];
        in.readFully(array);
        return array;
    }

    public static void marshallSize(ObjectOutput out, int value) throws IOException {
        if (value < 0) {
            out.writeByte(128);
            return;
        }
        if ((value & 0xFFFFFFC0) == 0) {
            out.writeByte(value & 0x3F);
            return;
        }
        out.writeByte(value & 0x3F | 0x40);
        value >>>= 6;
        while ((value & 0xFFFFFF80) != 0) {
            out.writeByte((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        out.writeByte((byte)value);
    }

    public static int unmarshallSize(ObjectInput in) throws IOException {
        byte b = in.readByte();
        if ((b & 0x80) != 0) {
            return -1;
        }
        int i = b & 0x3F;
        if ((b & 0x40) == 0) {
            return i;
        }
        int shift = 6;
        do {
            b = in.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return i;
    }

    public static <E extends Enum<E>> void marshallEnum(E e, ObjectOutput output) throws IOException {
        if (e == null) {
            output.writeByte(-1);
        } else {
            output.writeByte(e.ordinal());
        }
    }

    public static <E extends Enum<E>> E unmarshallEnum(ObjectInput input, EnumBuilder<E> builder) throws IOException {
        byte ordinal = input.readByte();
        if (ordinal == -1) {
            return null;
        }
        try {
            return Objects.requireNonNull(builder).build(ordinal);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Unknown enum.", e);
        }
    }

    public static void marshallIntCollection(Collection<Integer> collection, ObjectOutput out) throws IOException {
        int size = collection == null ? -1 : collection.size();
        MarshallUtil.marshallSize(out, size);
        if (size <= 0) {
            return;
        }
        for (Integer integer : collection) {
            out.writeInt(integer);
        }
    }

    public static <T extends Collection<Integer>> T unmarshallIntCollection(ObjectInput in, CollectionBuilder<Integer, T> builder) throws IOException {
        int size = MarshallUtil.unmarshallSize(in);
        if (size == -1) {
            return null;
        }
        T collection = Objects.requireNonNull(builder, "CollectionBuilder must be non-null").build(size);
        for (int i = 0; i < size; ++i) {
            collection.add(in.readInt());
        }
        return collection;
    }

    public static boolean isSafeClass(String className, List<String> whitelist) {
        for (String whiteRegExp : whitelist) {
            Pattern whitePattern = Pattern.compile(whiteRegExp);
            Matcher whiteMatcher = whitePattern.matcher(className);
            if (!whiteMatcher.find()) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Whitelist match: '%s'", className);
            }
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface ElementWriter<E> {
        public void writeTo(ObjectOutput var1, E var2) throws IOException;
    }

    @FunctionalInterface
    public static interface ElementReader<E> {
        public E readFrom(ObjectInput var1) throws ClassNotFoundException, IOException;
    }

    @FunctionalInterface
    public static interface EnumBuilder<E extends Enum<E>> {
        public E build(int var1);
    }

    @FunctionalInterface
    public static interface MapBuilder<K, V, T extends Map<K, V>> {
        public T build(int var1);
    }

    @FunctionalInterface
    public static interface UnboundedCollectionBuilder<E, T extends Collection<E>> {
        public T build();
    }

    @FunctionalInterface
    public static interface CollectionBuilder<E, T extends Collection<E>> {
        public T build(int var1);
    }

    @FunctionalInterface
    public static interface ArrayBuilder<E> {
        public E[] build(int var1);
    }
}

