/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.SecureRandom;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import org.infinispan.commons.test.BlockHoundHelper;
import org.infinispan.commons.test.TestSuiteProgress;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CommonsTestBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.addDynamicThreadPredicate(t -> t.getName().startsWith("testng") || t.getName().startsWith("ForkThread"));
        builder.nonBlockingThreadPredicate(threadPredicate -> threadPredicate.or(t -> BlockHoundHelper.currentThreadRequiresNonBlocking()));
        builder.allowBlockingCallsInside(SecureRandom.class.getName(), "nextBytes");
        CommonsTestBlockHoundIntegration.registerAllPublicMethodsOnClass(builder, ThreadPoolExecutor.class);
        CommonsTestBlockHoundIntegration.registerAllPublicMethodsOnClass(builder, ScheduledThreadPoolExecutor.class);
        builder.allowBlockingCallsInside(ThreadPoolExecutor.class.getName(), "getTask");
        builder.allowBlockingCallsInside(ThreadPoolExecutor.class.getName(), "processWorkerExit");
        CommonsTestBlockHoundIntegration.registerAllPublicMethodsOnClass(builder, TestSuiteProgress.class);
        builder.allowBlockingCallsInside(org.apache.logging.log4j.core.Logger.class.getName(), "logMessage");
        builder.allowBlockingCallsInside(Logger.class.getName(), "log");
    }

    private static void registerAllPublicMethodsOnClass(BlockHound.Builder builder, Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            builder.allowBlockingCallsInside(clazz.getName(), method.getName());
        }
    }
}

