/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.concurrent.Executor;
import java.util.function.Supplier;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class BlockHoundHelper {
    private static final ThreadLocal<Boolean> isNonBlocking = ThreadLocal.withInitial(() -> Boolean.FALSE);

    private BlockHoundHelper() {
    }

    static void installBlockHound() {
        Thread otherThread = new Thread(() -> BlockHound.install((BlockHoundIntegration[])new BlockHoundIntegration[0]));
        otherThread.start();
        try {
            otherThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean currentThreadRequiresNonBlocking() {
        return isNonBlocking.get() == Boolean.TRUE;
    }

    public static <V> V ensureNonBlocking(Supplier<V> supplier) {
        Boolean previousSetting = isNonBlocking.get();
        isNonBlocking.set(Boolean.TRUE);
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            isNonBlocking.set(previousSetting);
        }
    }

    public static void ensureNonBlocking(Runnable runnable) {
        Boolean previousSetting = isNonBlocking.get();
        isNonBlocking.set(Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            isNonBlocking.set(previousSetting);
        }
    }

    public static Executor ensureNonBlockingExecutor() {
        return BlockHoundHelper::ensureNonBlocking;
    }
}

