/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test.skip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class StringLogAppender
extends AbstractAppender {
    private final String category;
    private final Level level;
    private final List<String> logs;
    private final Predicate<Thread> threadFilter;

    public StringLogAppender(String category, Level level, Predicate<Thread> threadFilter, Layout layout) {
        super(StringLogAppender.class.getName(), null, layout);
        this.category = category;
        this.level = level;
        this.logs = Collections.synchronizedList(new ArrayList());
        this.threadFilter = threadFilter;
    }

    public void install() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        this.start();
        config.addAppender((Appender)this);
        AppenderRef ref = AppenderRef.createAppenderRef((String)this.getName(), (Level)this.level, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)true, (Level)this.level, (String)this.category, null, (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)this, null, null);
        config.addLogger(this.category, loggerConfig);
        loggerContext.updateLoggers();
    }

    public void uninstall() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        loggerContext.getConfiguration().removeLogger(this.category);
        loggerContext.updateLoggers();
    }

    public void append(LogEvent event) {
        if (this.threadFilter.test(Thread.currentThread())) {
            this.logs.add((String)((Object)this.getLayout().toSerializable(event)));
        }
    }

    public String getLog(int index) {
        if (index < 0 || index >= this.logs.size()) {
            throw new IllegalArgumentException("Index " + index + " is out of bounds: [0.." + this.logs.size() + "]");
        }
        return this.logs.get(index);
    }
}

