/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import org.infinispan.commons.test.RunningTestsRegistry;
import org.infinispan.commons.test.TestSuiteProgress;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTestListener
extends RunListener {
    private ThreadLocal<Boolean> currentTestIsSuccessful = new ThreadLocal();
    private final TestSuiteProgress progressLogger = new TestSuiteProgress();
    private String currentTestName;

    public void testStarted(Description description) throws Exception {
        String testName = this.testName(description);
        String simpleName = description.getTestClass().getSimpleName();
        this.progressLogger.testStarted(testName);
        RunningTestsRegistry.registerThreadWithTest(testName, simpleName);
        this.currentTestIsSuccessful.set(true);
    }

    public void testFinished(Description description) throws Exception {
        RunningTestsRegistry.unregisterThreadWithTest();
        if (this.currentTestIsSuccessful.get().booleanValue()) {
            this.progressLogger.testSucceeded(this.testName(description));
        }
    }

    public void testFailure(Failure failure) throws Exception {
        this.currentTestIsSuccessful.set(false);
        this.progressLogger.testFailed(this.testName(failure.getDescription()), failure.getException());
    }

    public void testIgnored(Description description) throws Exception {
        this.currentTestIsSuccessful.set(false);
        this.progressLogger.testIgnored(this.testName(description));
    }

    public void testAssumptionFailure(Failure failure) {
        this.currentTestIsSuccessful.set(false);
        this.progressLogger.testAssumptionFailed(this.testName(failure.getDescription()), failure.getException());
    }

    private String testName(Description description) {
        String className = description.isSuite() ? "suite" : description.getTestClass().getSimpleName();
        return className + "." + description.getMethodName();
    }

    public void testRunStarted(Description description) throws Exception {
        ThreadLeakChecker.saveInitialThreads();
    }

    public void testRunFinished(Result result) {
        try {
            ThreadLeakChecker.checkForLeaks(null);
        }
        catch (Throwable e) {
            this.progressLogger.configurationFailed("[ERROR]", e);
        }
    }
}

