/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.graalvm;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.graalvm.NativeMetadataProvider;

public class NativeMetadataWriter {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException(String.format("FQN of '%s' implementation must be provided as the first arg", NativeMetadataProvider.class));
        }
        NativeMetadataProvider metadata = (NativeMetadataProvider)Class.forName(args[0]).getConstructor(new Class[0]).newInstance(new Object[0]);
        String rootDir = args.length > 1 ? args[1] : "";
        Files.createDirectories(Paths.get(rootDir, new String[0]), new FileAttribute[0]);
        Json reflection = NativeMetadataWriter.array(metadata.reflectiveClasses().sorted());
        Json resource = Json.object().set("resources", Json.object().set("includes", NativeMetadataWriter.array(metadata.includedResources()))).set("bundles", NativeMetadataWriter.array(metadata.bundles()));
        Files.writeString(Paths.get(rootDir, "reflection-config.json"), (CharSequence)reflection.toPrettyString(), new OpenOption[0]);
        Files.writeString(Paths.get(rootDir, "resource-config.json"), (CharSequence)resource.toPrettyString(), new OpenOption[0]);
    }

    private static Json array(Stream<? extends JsonSerialization> stream) {
        return Json.make(stream.map(JsonSerialization::toJson).collect(Collectors.toList()));
    }
}

