/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.weak;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.function.AddFunction;
import org.infinispan.counter.impl.function.InitializeCounterFunction;
import org.infinispan.counter.impl.function.ResetFunction;
import org.infinispan.counter.impl.listener.CounterEventGenerator;
import org.infinispan.counter.impl.listener.CounterEventImpl;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.listener.TopologyChangeListener;
import org.infinispan.counter.impl.weak.WeakCounterKey;
import org.infinispan.counter.logging.Log;
import org.infinispan.counter.util.Utils;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.util.ByteString;

public class WeakCounterImpl
implements WeakCounter,
CounterEventGenerator,
TopologyChangeListener {
    private static final Log log = (Log)LogFactory.getLog(WeakCounterImpl.class, Log.class);
    private static final AtomicReferenceFieldUpdater<Entry, Long> L1_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Entry.class, Long.class, "snapshot");
    private final Entry[] entries;
    private final AdvancedCache<WeakCounterKey, CounterValue> cache;
    private final FunctionalMap.ReadWriteMap<WeakCounterKey, CounterValue> readWriteMap;
    private final CounterManagerNotificationManager notificationManager;
    private final CounterConfiguration configuration;
    private final KeySelector selector;

    public WeakCounterImpl(String counterName, AdvancedCache<WeakCounterKey, CounterValue> cache, CounterConfiguration configuration, CounterManagerNotificationManager notificationManager) {
        this.cache = cache;
        this.notificationManager = notificationManager;
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(cache).withParams(new Param[]{Utils.getPersistenceMode(configuration.storage())});
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entries = WeakCounterImpl.initKeys(counterName, configuration.concurrencyLevel());
        this.selector = new KeySelector(this.entries);
        this.configuration = configuration;
    }

    private static <T> T get(int hash, T[] array) {
        return array[hash & array.length - 1];
    }

    private static Entry[] initKeys(String counterName, int concurrencyLevel) {
        ByteString name = ByteString.fromString((String)counterName);
        int size = Util.findNextHighestPowerOfTwo((int)concurrencyLevel);
        Entry[] entries = new Entry[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = new Entry(new WeakCounterKey(name, i));
        }
        return entries;
    }

    public void init() {
        this.registerListener();
        this.initEntry(0, this.configuration);
        CounterConfiguration zeroConfig = CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(0L).storage(this.configuration.storage()).build();
        for (int i = 1; i < this.entries.length; ++i) {
            this.initEntry(i, zeroConfig);
        }
        this.selector.updatePreferredKeys();
    }

    private void initEntry(int index, CounterConfiguration configuration) {
        try {
            CounterValue existing = (CounterValue)this.readWriteMap.eval((Object)this.entries[index].key, new InitializeCounterFunction(configuration)).get();
            this.entries[index].init(existing.getValue());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CounterException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Utils.rethrowAsCounterException(e);
        }
    }

    public String getName() {
        return this.counterName().toString();
    }

    public long getValue() {
        return this.getCachedValue();
    }

    public CompletableFuture<Void> add(long delta) {
        return this.readWriteMap.eval((Object)this.findKey(), new AddFunction(delta)).thenApply(this::handleAddResult);
    }

    public CompletableFuture<Void> reset() {
        int size = this.entries.length;
        CompletableFuture[] futures = new CompletableFuture[size];
        for (int i = 0; i < size; ++i) {
            futures[i] = this.readWriteMap.eval((Object)this.entries[i].key, ResetFunction.getInstance());
        }
        return CompletableFuture.allOf(futures);
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.registerUserListener(this.counterName(), listener);
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public CounterEvent generate(CounterKey key, CounterValue value) {
        assert (key instanceof WeakCounterKey);
        int index = ((WeakCounterKey)key).getIndex();
        long base = this.getCachedValue(index);
        long newValue = value.getValue();
        long oldValue = this.updateCounterState(index, newValue);
        return CounterEventImpl.create(base + oldValue, base + newValue);
    }

    @Override
    public void topologyChanged() {
        this.selector.updatePreferredKeys();
    }

    public WeakCounterKey[] getPreferredKeys() {
        return this.selector.preferredKeys;
    }

    public WeakCounterKey[] getKeys() {
        WeakCounterKey[] keys = new WeakCounterKey[this.entries.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.entries[i].key;
        }
        return keys;
    }

    private long getCachedValue() {
        int index;
        long value = 0L;
        try {
            for (index = 0; index < this.entries.length; ++index) {
                value = Math.addExact(value, this.entries[index].snapshot);
            }
        }
        catch (ArithmeticException e) {
            return this.getCachedValue0(index, value, -1);
        }
        return value;
    }

    private long getCachedValue(int skipIndex) {
        int index;
        long value = 0L;
        try {
            for (index = 0; index < this.entries.length; ++index) {
                if (index == skipIndex) continue;
                value = Math.addExact(value, this.entries[index].snapshot);
            }
        }
        catch (ArithmeticException e) {
            return this.getCachedValue0(index, value, skipIndex);
        }
        return value;
    }

    private long getCachedValue0(int index, long value, int skipIndex) {
        BigInteger currentValue = BigInteger.valueOf(value);
        do {
            currentValue = currentValue.add(BigInteger.valueOf(this.entries[index++].snapshot));
            if (index != skipIndex) continue;
            ++index;
        } while (index < this.entries.length);
        try {
            return currentValue.longValue();
        }
        catch (ArithmeticException e) {
            return currentValue.signum() > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    private long updateCounterState(int index, long newValue) {
        return this.entries[index].update(newValue);
    }

    private Void handleAddResult(CounterValue counterValue) {
        if (counterValue == null) {
            throw new CompletionException((Throwable)log.counterDeleted());
        }
        return null;
    }

    private void registerListener() {
        this.notificationManager.registerCounter(this.counterName(), this, this);
    }

    private WeakCounterKey findKey() {
        return this.selector.findKey((int)Thread.currentThread().getId());
    }

    public String toString() {
        return "WeakCounter{counterName=" + this.counterName() + '}';
    }

    private ByteString counterName() {
        return this.entries[0].key.getCounterName();
    }

    private class KeySelector {
        private final Entry[] entries;
        private volatile WeakCounterKey[] preferredKeys;

        private KeySelector(Entry[] entries) {
            this.entries = entries;
        }

        private WeakCounterKey findKey(int hash) {
            Object[] copy = this.preferredKeys;
            if (copy == null) {
                return ((Entry)WeakCounterImpl.get((int)hash, (Object[])this.entries)).key;
            }
            if (copy.length == 1) {
                return copy[0];
            }
            return (WeakCounterKey)WeakCounterImpl.get(hash, copy);
        }

        private void updatePreferredKeys() {
            ArrayList<WeakCounterKey> preferredKeys = new ArrayList<WeakCounterKey>(this.entries.length);
            LocalizedCacheTopology topology = WeakCounterImpl.this.cache.getDistributionManager().getCacheTopology();
            for (Entry entry : this.entries) {
                if (!topology.getDistribution((Object)entry.key).isPrimary()) continue;
                preferredKeys.add(entry.key);
            }
            this.preferredKeys = preferredKeys.isEmpty() ? null : preferredKeys.toArray(new WeakCounterKey[preferredKeys.size()]);
        }
    }

    private static class Entry {
        final WeakCounterKey key;
        volatile Long snapshot;

        private Entry(WeakCounterKey key) {
            this.key = key;
        }

        private void init(long initialValue) {
            L1_UPDATER.compareAndSet(this, null, initialValue);
        }

        private long update(long value) {
            return L1_UPDATER.getAndSet(this, value);
        }
    }
}

