/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.listener;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.util.ByteString;

public class CounterFilterAndConvert<T extends CounterKey>
extends AbstractCacheEventFilterConverter<T, CounterValue, CounterValue> {
    public static final AdvancedExternalizer<CounterFilterAndConvert> EXTERNALIZER = new Externalizer();
    private final ByteString counterName;

    public CounterFilterAndConvert(ByteString counterName) {
        this.counterName = Objects.requireNonNull(counterName);
    }

    public CounterValue filterAndConvert(T key, CounterValue oldValue, Metadata oldMetadata, CounterValue newValue, Metadata newMetadata, EventType eventType) {
        if (this.counterName.equals((Object)key.getCounterName()) && newValue != null && eventType.isModified()) {
            return newValue;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CounterFilterAndConvert that = (CounterFilterAndConvert)((Object)o);
        return this.counterName.equals((Object)that.counterName);
    }

    public int hashCode() {
        return this.counterName.hashCode();
    }

    public String toString() {
        return "CounterFilterAndConvert{counterName=" + this.counterName + '}';
    }

    private static class Externalizer
    implements AdvancedExternalizer<CounterFilterAndConvert> {
        private Externalizer() {
        }

        public Set<Class<? extends CounterFilterAndConvert>> getTypeClasses() {
            return Collections.singleton(CounterFilterAndConvert.class);
        }

        public Integer getId() {
            return ExternalizerIds.CONVERTER_AND_FILTER;
        }

        public void writeObject(ObjectOutput output, CounterFilterAndConvert object) throws IOException {
            ByteString.writeObject((ObjectOutput)output, (ByteString)object.counterName);
        }

        public CounterFilterAndConvert readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CounterFilterAndConvert(ByteString.readObject((ObjectInput)input));
        }
    }
}

