/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.concurrent.CompletionStage;
import okhttp3.Request;
import org.infinispan.client.rest.RestMetricsClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;

public class RestMetricsClientOkHttp
implements RestMetricsClient {
    private final RestClientOkHttp client;
    private final String baseMetricsURL;

    RestMetricsClientOkHttp(RestClientOkHttp client) {
        this.client = client;
        this.baseMetricsURL = String.format("%s/metrics", client.getBaseURL());
    }

    @Override
    public CompletionStage<RestResponse> metrics() {
        return this.metricsGet("", false);
    }

    @Override
    public CompletionStage<RestResponse> metrics(String path) {
        return this.metricsGet(path, false);
    }

    @Override
    public CompletionStage<RestResponse> metrics(boolean openMetricsFormat) {
        return this.metricsGet("", openMetricsFormat);
    }

    @Override
    public CompletionStage<RestResponse> metrics(String path, boolean openMetricsFormat) {
        return this.metricsGet(path, openMetricsFormat);
    }

    @Override
    public CompletionStage<RestResponse> metricsMetadata() {
        return this.metricsOptions("");
    }

    @Override
    public CompletionStage<RestResponse> metricsMetadata(String path) {
        return this.metricsOptions(path);
    }

    private CompletionStage<RestResponse> metricsGet(String path, boolean openMetricsFormat) {
        Request.Builder builder = new Request.Builder().addHeader("ACCEPT", openMetricsFormat ? "application/openmetrics-text" : "application/json");
        return this.client.execute(builder, this.baseMetricsURL, path);
    }

    private CompletionStage<RestResponse> metricsOptions(String path) {
        Request.Builder builder = new Request.Builder().method("OPTIONS", null);
        return this.client.execute(builder, this.baseMetricsURL, path);
    }
}

