/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.dataconversion.MediaType;

public class RestResponseOkHttp
implements RestResponse {
    private final Response response;

    RestResponseOkHttp(Response response) {
        this.response = response;
    }

    @Override
    public int getStatus() {
        return this.response.code();
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.response.headers().toMultimap();
    }

    @Override
    public String getHeader(String header) {
        List values = this.response.headers(header);
        if (values.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", values);
    }

    @Override
    public String getBody() {
        try {
            return this.response.body().string();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getBodyAsStream() {
        return this.response.body().byteStream();
    }

    @Override
    public byte[] getBodyAsByteArray() {
        try {
            return this.response.body().bytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MediaType contentType() {
        okhttp3.MediaType mediaType = this.response.body().contentType();
        return mediaType == null ? null : MediaType.fromString((String)mediaType.toString());
    }

    @Override
    public Protocol getProtocol() {
        switch (this.response.protocol()) {
            case H2_PRIOR_KNOWLEDGE: 
            case HTTP_2: {
                return Protocol.HTTP_20;
            }
            case HTTP_1_1: {
                return Protocol.HTTP_11;
            }
        }
        throw new IllegalStateException("Unknown protocol " + String.valueOf(this.response.protocol()));
    }

    @Override
    public void close() {
        this.response.close();
    }

    @Override
    public boolean usedAuthentication() {
        return !this.response.request().headers("Authorization").isEmpty();
    }
}

