/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;

public class RestURI {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final List<InetSocketAddress> addresses;
    private final boolean ssl;
    private final String username;
    private final String password;
    private final Properties properties;

    public static RestURI create(String uriString) {
        return RestURI.create(URI.create(uriString));
    }

    public static RestURI create(URI uri) {
        String[] userInfo;
        List<InetSocketAddress> addresses;
        if (!"http".equals(uri.getScheme()) && !"https".equals(uri.getScheme())) {
            throw new IllegalArgumentException(uri.toString());
        }
        if (uri.getHost() != null) {
            addresses = Collections.singletonList(InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort() < 0 ? 11222 : uri.getPort()));
            userInfo = uri.getUserInfo() != null ? uri.getUserInfo().split(":") : EMPTY_STRING_ARRAY;
        } else {
            String authority = uri.getAuthority();
            int at = authority.indexOf(64);
            userInfo = at < 0 ? EMPTY_STRING_ARRAY : authority.substring(0, at).split(":");
            String[] hosts = at < 0 ? authority.split(",") : authority.substring(at + 1).split(",");
            addresses = new ArrayList<InetSocketAddress>(hosts.length);
            String[] stringArray = hosts;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String host = stringArray[i];
                int colon = host.lastIndexOf(58);
                addresses.add(InetSocketAddress.createUnresolved(colon < 0 ? host : host.substring(0, colon), colon < 0 ? 11222 : Integer.parseInt(host.substring(colon + 1))));
            }
        }
        Properties properties = new Properties();
        if (uri.getQuery() != null) {
            String[] parts;
            for (String part : parts = uri.getQuery().split("&")) {
                int eq = part.indexOf(61);
                if (eq < 0) {
                    throw new IllegalArgumentException(part);
                }
                properties.setProperty("infinispan.client.rest." + part.substring(0, eq), part.substring(eq + 1));
            }
        }
        return new RestURI(addresses, "https".equals(uri.getScheme()), userInfo.length > 0 ? userInfo[0] : null, userInfo.length > 1 ? userInfo[1] : null, properties);
    }

    private RestURI(List<InetSocketAddress> addresses, boolean ssl, String username, String password, Properties properties) {
        this.addresses = addresses;
        this.ssl = ssl;
        this.username = username;
        this.password = password;
        this.properties = properties;
    }

    public List<InetSocketAddress> getAddresses() {
        return this.addresses;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public RestClientConfigurationBuilder toConfigurationBuilder() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        for (InetSocketAddress address : this.addresses) {
            builder.addServer().host(address.getHostString()).port(address.getPort());
        }
        if (this.ssl) {
            builder.security().ssl().enable();
        }
        if (this.username != null) {
            builder.security().authentication().username(this.username);
        }
        if (this.password != null) {
            builder.security().authentication().password(this.password);
        }
        builder.withProperties(this.properties);
        return builder;
    }

    public String toString() {
        return "RestURI{addresses=" + this.addresses + ", ssl=" + this.ssl + ", username='" + this.username + "', password='" + this.password + "', properties=" + this.properties + "}";
    }
}

