/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.infinispan.cdi.util.Contracts;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.jcache.JCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

@ApplicationScoped
@Alternative
public class InjectedCacheResolver
implements CacheResolver {
    private Instance<EmbeddedCacheManager> cacheManagers;
    private EmbeddedCacheManager defaultCacheManager;
    private Map<EmbeddedCacheManager, JCacheManager> jcacheManagers = new HashMap<EmbeddedCacheManager, JCacheManager>();
    private JCacheManager defaultJCacheManager;

    @Inject
    public InjectedCacheResolver(@Any Instance<EmbeddedCacheManager> cacheManagers) {
        this.cacheManagers = cacheManagers;
        for (EmbeddedCacheManager cacheManager : cacheManagers) {
            this.jcacheManagers.put(cacheManager, this.toJCacheManager(cacheManager));
        }
        this.defaultCacheManager = (EmbeddedCacheManager)cacheManagers.select(new Annotation[]{new AnnotationLiteral<Default>(){}}).get();
        this.defaultJCacheManager = this.jcacheManagers.get(this.defaultCacheManager);
    }

    private JCacheManager toJCacheManager(EmbeddedCacheManager cacheManager) {
        GlobalConfiguration globalCfg = cacheManager.getCacheManagerConfiguration();
        String name = globalCfg.globalJmxStatistics().cacheManagerName();
        return new JCacheManager(URI.create(name), cacheManager, Caching.getCachingProvider());
    }

    InjectedCacheResolver() {
    }

    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cacheInvocationContext) {
        Contracts.assertNotNull(cacheInvocationContext, "cacheInvocationContext parameter must not be null");
        String cacheName = cacheInvocationContext.getCacheName();
        if (cacheName.trim().isEmpty()) {
            return this.getCacheFromDefaultCacheManager(cacheName);
        }
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            Set cacheNames = cm.getCacheNames();
            for (String name : cacheNames) {
                if (!name.equals(cacheName)) continue;
                JCacheManager jcacheManager = this.jcacheManagers.get(cm);
                Cache cache = jcacheManager.getCache(cacheName);
                if (cache != null) {
                    return cache;
                }
                return jcacheManager.configureCache(cacheName, cm.getCache(cacheName).getAdvancedCache());
            }
        }
        return this.getCacheFromDefaultCacheManager(cacheName);
    }

    private <K, V> Cache<K, V> getCacheFromDefaultCacheManager(String cacheName) {
        Cache cache = this.defaultJCacheManager.getCache(cacheName);
        if (cache != null) {
            return cache;
        }
        return this.defaultJCacheManager.configureCache(cacheName, this.defaultCacheManager.getCache().getAdvancedCache());
    }
}

