/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheRemoveEntry;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.AnnotationLiteral;
import org.infinispan.cdi.ConfigureCache;
import org.infinispan.cdi.Remote;
import org.infinispan.cdi.RemoteCacheProducer;
import org.infinispan.cdi.event.cachemanager.CacheManagerEventBridge;
import org.infinispan.cdi.interceptor.CachePutInterceptor;
import org.infinispan.cdi.interceptor.CacheRemoveAllInterceptor;
import org.infinispan.cdi.interceptor.CacheRemoveEntryInterceptor;
import org.infinispan.cdi.interceptor.CacheResultInterceptor;
import org.infinispan.cdi.interceptor.literal.CachePutLiteral;
import org.infinispan.cdi.interceptor.literal.CacheRemoveAllLiteral;
import org.infinispan.cdi.interceptor.literal.CacheRemoveEntryLiteral;
import org.infinispan.cdi.interceptor.literal.CacheResultLiteral;
import org.infinispan.cdi.util.Version;
import org.infinispan.cdi.util.logging.Log;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.infinispan.util.logging.LogFactory;
import org.jboss.solder.bean.BeanBuilder;
import org.jboss.solder.bean.Beans;
import org.jboss.solder.bean.ContextualLifecycle;
import org.jboss.solder.reflection.AnnotationInspector;
import org.jboss.solder.reflection.Reflections;
import org.jboss.solder.reflection.annotated.AnnotatedTypeBuilder;

public class InfinispanExtension
implements Extension {
    private static final Log log = (Log)LogFactory.getLog(InfinispanExtension.class, Log.class);
    private Producer<RemoteCache> remoteCacheProducer;
    private final Set<ConfigurationHolder> configurations = new HashSet<ConfigurationHolder>();
    private final Map<Type, Set<Annotation>> remoteCacheInjectionPoints = new HashMap<Type, Set<Annotation>>();

    InfinispanExtension() {
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery event) {
        log.version(Version.getVersion());
        event.addInterceptorBinding(CacheResult.class, new Annotation[0]);
        event.addInterceptorBinding(CachePut.class, new Annotation[0]);
        event.addInterceptorBinding(CacheRemoveEntry.class, new Annotation[0]);
        event.addInterceptorBinding(CacheRemoveAll.class, new Annotation[0]);
    }

    void registerCacheResultInterceptor(@Observes ProcessAnnotatedType<CacheResultInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheResultLiteral.INSTANCE)).create());
    }

    void registerCachePutInterceptor(@Observes ProcessAnnotatedType<CachePutInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CachePutLiteral.INSTANCE)).create());
    }

    void registerCacheRemoveEntryInterceptor(@Observes ProcessAnnotatedType<CacheRemoveEntryInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheRemoveEntryLiteral.INSTANCE)).create());
    }

    void registerCacheRemoveAllInterceptor(@Observes ProcessAnnotatedType<CacheRemoveAllInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheRemoveAllLiteral.INSTANCE)).create());
    }

    void saveRemoteCacheProducer(@Observes ProcessProducer<RemoteCacheProducer, RemoteCache> event) {
        this.remoteCacheProducer = event.getProducer();
    }

    <T> void saveRemoteInjectionPoints(@Observes ProcessInjectionTarget<T> event, BeanManager beanManager) {
        InjectionTarget injectionTarget = event.getInjectionTarget();
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            Annotated annotated = injectionPoint.getAnnotated();
            Type type = annotated.getBaseType();
            Class rawType = Reflections.getRawType((Type)annotated.getBaseType());
            Set qualifiers = Beans.getQualifiers((BeanManager)beanManager, (Iterable)annotated.getAnnotations());
            if (rawType.equals(RemoteCache.class) && qualifiers.isEmpty()) {
                qualifiers.add(new AnnotationLiteral<Default>(){});
                this.addRemoteCacheInjectionPoint(type, qualifiers);
                continue;
            }
            if (annotated.isAnnotationPresent(Remote.class) || AnnotationInspector.getMetaAnnotation((Annotated)annotated, Remote.class) == null || !rawType.isAssignableFrom(RemoteCache.class)) continue;
            this.addRemoteCacheInjectionPoint(type, qualifiers);
        }
    }

    private void addRemoteCacheInjectionPoint(Type type, Set<Annotation> qualifiers) {
        Set<Annotation> currentQualifiers = this.remoteCacheInjectionPoints.get(type);
        if (currentQualifiers == null) {
            this.remoteCacheInjectionPoints.put(type, qualifiers);
        } else {
            currentQualifiers.addAll(qualifiers);
        }
    }

    void saveCacheConfigurations(@Observes ProcessProducer<?, Configuration> event, BeanManager beanManager) {
        ConfigureCache annotation = (ConfigureCache)event.getAnnotatedMember().getAnnotation(ConfigureCache.class);
        if (annotation != null) {
            this.configurations.add(new ConfigurationHolder((Producer<Configuration>)event.getProducer(), annotation.value(), Beans.getQualifiers((BeanManager)beanManager, (Iterable)event.getAnnotatedMember().getAnnotations())));
        }
    }

    void registerRemoteCacheBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (Map.Entry<Type, Set<Annotation>> entry : this.remoteCacheInjectionPoints.entrySet()) {
            event.addBean(new BeanBuilder(beanManager).readFromType(beanManager.createAnnotatedType(Reflections.getRawType((Type)entry.getKey()))).addType(entry.getKey()).addQualifiers((Collection)entry.getValue()).beanLifecycle((ContextualLifecycle)new ContextualLifecycle<RemoteCache>(){

                public RemoteCache create(Bean<RemoteCache> bean, CreationalContext<RemoteCache> ctx) {
                    return (RemoteCache)InfinispanExtension.this.remoteCacheProducer.produce(ctx);
                }

                public void destroy(Bean<RemoteCache> bean, RemoteCache instance, CreationalContext<RemoteCache> ctx) {
                    InfinispanExtension.this.remoteCacheProducer.dispose((Object)instance);
                }
            }).create());
        }
    }

    void registerCacheConfigurations(@Observes AfterDeploymentValidation event, CacheManagerEventBridge eventBridge, @Any Instance<EmbeddedCacheManager> cacheManagers, BeanManager beanManager) {
        CreationalContext ctx = beanManager.createCreationalContext(null);
        EmbeddedCacheManager defaultCacheManager = (EmbeddedCacheManager)cacheManagers.select(new Annotation[]{new AnnotationLiteral<Default>(){}}).get();
        for (ConfigurationHolder oneConfigurationHolder : this.configurations) {
            EmbeddedCacheManager cacheManager;
            String cacheName = oneConfigurationHolder.getName();
            Configuration cacheConfiguration = (Configuration)oneConfigurationHolder.getProducer().produce(ctx);
            Set<Annotation> cacheQualifiers = oneConfigurationHolder.getQualifiers();
            Instance specificCacheManager = cacheManagers.select(cacheQualifiers.toArray(new Annotation[cacheQualifiers.size()]));
            EmbeddedCacheManager embeddedCacheManager = cacheManager = specificCacheManager.isUnsatisfied() ? defaultCacheManager : (EmbeddedCacheManager)specificCacheManager.get();
            if (!cacheName.trim().isEmpty()) {
                if (cacheConfiguration != null) {
                    cacheManager.defineConfiguration(cacheName, cacheConfiguration);
                    log.cacheConfigurationDefined(cacheName, cacheManager);
                } else if (!cacheManager.getCacheNames().contains(cacheName)) {
                    cacheManager.defineConfiguration(cacheName, cacheManager.getDefaultCacheConfiguration());
                    log.cacheConfigurationDefined(cacheName, cacheManager);
                }
            }
            eventBridge.registerObservers(cacheQualifiers, cacheName, (Listenable)cacheManager);
        }
    }

    static class ConfigurationHolder {
        private final Producer<Configuration> producer;
        private final Set<Annotation> qualifiers;
        private final String name;

        ConfigurationHolder(Producer<Configuration> producer, String name, Set<Annotation> qualifiers) {
            this.producer = producer;
            this.name = name;
            this.qualifiers = qualifiers;
        }

        public Producer<Configuration> getProducer() {
            return this.producer;
        }

        public String getName() {
            return this.name;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }
    }
}

