/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.cache.interceptor.CacheInvocationParameter;
import javax.cache.interceptor.CacheKeyGenerator;
import javax.cache.interceptor.CacheKeyInvocationContext;
import javax.interceptor.InvocationContext;
import org.infinispan.cdi.interceptor.context.CacheInvocationParameterImpl;
import org.infinispan.cdi.interceptor.context.metadata.MethodMetaData;
import org.infinispan.cdi.interceptor.context.metadata.ParameterMetaData;

public class CacheKeyInvocationContextImpl<A extends Annotation>
implements CacheKeyInvocationContext<A> {
    private final InvocationContext invocationContext;
    private final MethodMetaData<A> methodMetaData;
    private final CacheInvocationParameter[] allParameters;
    private final CacheInvocationParameter[] keyParameters;
    private final CacheInvocationParameter valueParameter;

    public CacheKeyInvocationContextImpl(InvocationContext invocationContext, MethodMetaData<A> methodMetaData) {
        this.invocationContext = invocationContext;
        this.methodMetaData = methodMetaData;
        Object[] parameters = invocationContext.getParameters();
        List<ParameterMetaData> parametersMetaData = methodMetaData.getParameters();
        this.allParameters = new CacheInvocationParameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.allParameters[i] = new CacheInvocationParameterImpl(parametersMetaData.get(i), parameters[i]);
        }
        List<ParameterMetaData> keyParametersMetaData = methodMetaData.getKeyParameters();
        int i = 0;
        this.keyParameters = new CacheInvocationParameter[keyParametersMetaData.size()];
        for (ParameterMetaData oneKeyParameterMetaData : keyParametersMetaData) {
            this.keyParameters[i] = this.allParameters[oneKeyParameterMetaData.getPosition()];
            ++i;
        }
        ParameterMetaData valueParameterMetaData = methodMetaData.getValueParameter();
        this.valueParameter = valueParameterMetaData != null ? this.allParameters[valueParameterMetaData.getPosition()] : null;
    }

    public Object getTarget() {
        return this.invocationContext.getTarget();
    }

    public CacheInvocationParameter[] getAllParameters() {
        return Arrays.copyOf(this.allParameters, this.allParameters.length);
    }

    public CacheInvocationParameter[] getKeyParameters() {
        return Arrays.copyOf(this.keyParameters, this.keyParameters.length);
    }

    public CacheInvocationParameter getValueParameter() {
        return this.valueParameter;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("The provider implementation cannot be unwrapped to " + cls);
    }

    public Method getMethod() {
        return this.methodMetaData.getMethod();
    }

    public Set<Annotation> getAnnotations() {
        return this.methodMetaData.getAnnotations();
    }

    public A getCacheAnnotation() {
        return this.methodMetaData.getCacheAnnotation();
    }

    public String getCacheName() {
        return this.methodMetaData.getCacheName();
    }

    public CacheKeyGenerator getCacheKeyGenerator() {
        return this.methodMetaData.getCacheKeyGenerator();
    }

    public String toString() {
        return "CacheKeyInvocationContextImpl{" + "invocationContext=" + this.invocationContext + ", methodMetaData=" + this.methodMetaData + ", allParameters=" + Arrays.deepToString(this.allParameters) + ", keyParameters=" + Arrays.deepToString(this.keyParameters) + ", valueParameter=" + this.valueParameter + '}';
    }
}

