/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor;

import java.lang.reflect.Method;
import javax.cache.CacheException;
import javax.cache.interceptor.CacheKey;
import javax.cache.interceptor.CacheRemoveEntry;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CacheResolver;
import org.infinispan.cdi.util.CacheHelper;

@Interceptor
public class CacheRemoveEntryInterceptor {
    private final CacheResolver cacheResolver;

    @Inject
    public CacheRemoveEntryInterceptor(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    @AroundInvoke
    public Object cacheRemoveEntry(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        CacheRemoveEntry cacheRemoveEntry = method.getAnnotation(CacheRemoveEntry.class);
        String cacheName = cacheRemoveEntry.cacheName();
        if (cacheName.trim().isEmpty()) {
            throw new CacheException("Method named '" + method.getName() + "' annotated with CacheRemoveEntry " + "doesn't specify a cache name");
        }
        Cache cache = this.cacheResolver.resolveCache(cacheName, method);
        CacheKey cacheKey = CacheHelper.generateCacheKey(cacheRemoveEntry.cacheKeyGenerator(), context);
        if (!cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
        }
        Object result = context.proceed();
        if (cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
        }
        return result;
    }
}

