/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor;

import java.lang.reflect.Method;
import javax.cache.interceptor.CacheKey;
import javax.cache.interceptor.CacheResult;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CacheResolver;
import org.infinispan.cdi.util.CacheHelper;

@Interceptor
public class CacheResultInterceptor {
    private final CacheResolver cacheResolver;

    @Inject
    public CacheResultInterceptor(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    @AroundInvoke
    public Object cacheResult(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        CacheResult cacheResult = method.getAnnotation(CacheResult.class);
        String cacheName = cacheResult.cacheName().trim().isEmpty() ? CacheHelper.getDefaultMethodCacheName(method) : cacheResult.cacheName();
        Cache cache = this.cacheResolver.resolveCache(cacheName, context.getMethod());
        CacheKey cacheKey = CacheHelper.generateCacheKey(cacheResult.cacheKeyGenerator(), context);
        Object methodResult = null;
        if (!cacheResult.skipGet()) {
            methodResult = cache.get((Object)cacheKey);
        }
        if (methodResult == null && (methodResult = context.proceed()) != null) {
            cache.put((Object)cacheKey, methodResult);
        }
        return methodResult;
    }
}

