/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.cache.interceptor.CacheRemoveAll;
import javax.cache.interceptor.CacheRemoveEntry;
import javax.cache.interceptor.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.AnnotationLiteral;
import org.infinispan.cdi.Infinispan;
import org.infinispan.cdi.event.cachemanager.CacheManagerEventBridge;
import org.infinispan.cdi.interceptor.CacheRemoveAllInterceptor;
import org.infinispan.cdi.interceptor.CacheRemoveEntryInterceptor;
import org.infinispan.cdi.interceptor.CacheResultInterceptor;
import org.infinispan.cdi.interceptor.literal.CacheRemoveAllLiteral;
import org.infinispan.cdi.interceptor.literal.CacheRemoveEntryLiteral;
import org.infinispan.cdi.interceptor.literal.CacheResultLiteral;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;

@ApplicationScoped
public class InfinispanExtension
implements Extension {
    private final Set<ConfigurationHolder> configurations = new HashSet<ConfigurationHolder>();

    InfinispanExtension() {
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery event) {
        event.addInterceptorBinding(CacheResult.class, new Annotation[0]);
        event.addInterceptorBinding(CacheRemoveEntry.class, new Annotation[0]);
        event.addInterceptorBinding(CacheRemoveAll.class, new Annotation[0]);
    }

    void registerCacheResultInterceptor(@Observes ProcessAnnotatedType<CacheResultInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheResultLiteral.INSTANCE)).create());
    }

    void registerCacheRemoveEntryInterceptor(@Observes ProcessAnnotatedType<CacheRemoveEntryInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheRemoveEntryLiteral.INSTANCE)).create());
    }

    void registerCacheRemoveAllInterceptor(@Observes ProcessAnnotatedType<CacheRemoveAllInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheRemoveAllLiteral.INSTANCE)).create());
    }

    void saveCacheConfigurations(@Observes ProcessProducer<?, Configuration> event, BeanManager beanManager) {
        Infinispan annotation = (Infinispan)event.getAnnotatedMember().getAnnotation(Infinispan.class);
        if (annotation != null) {
            String name = annotation.value();
            this.configurations.add(new ConfigurationHolder((Producer<Configuration>)event.getProducer(), name, event.getAnnotatedMember(), beanManager));
        }
    }

    void registerCacheConfigurations(@Observes AfterDeploymentValidation event, CacheManagerEventBridge eventBridge, @Any Instance<EmbeddedCacheManager> cacheContainers, BeanManager beanManager) {
        CreationalContext ctx = beanManager.createCreationalContext(null);
        Instance defaultCacheManager = cacheContainers.select(new Annotation[]{new AnnotationLiteral<Default>(){}});
        for (ConfigurationHolder oneConfigurationHolder : this.configurations) {
            String cacheName = oneConfigurationHolder.getName();
            Configuration configuration = (Configuration)oneConfigurationHolder.getProducer().produce(ctx);
            Set<Annotation> qualifiers = oneConfigurationHolder.getQualifiers();
            Instance cacheManager = cacheContainers.select(qualifiers.toArray(new Annotation[qualifiers.size()]));
            if (cacheManager.isUnsatisfied()) {
                cacheManager = defaultCacheManager;
            }
            if (!cacheName.isEmpty() && configuration != null) {
                ((EmbeddedCacheManager)cacheManager.get()).defineConfiguration(cacheName, configuration);
            }
            eventBridge.registerObservers(qualifiers, cacheName, (Listenable)cacheManager.get());
        }
    }

    static class ConfigurationHolder {
        private final Producer<Configuration> producer;
        private final Set<Annotation> qualifiers;
        private final String name;

        ConfigurationHolder(Producer<Configuration> producer, String name, AnnotatedMember<?> annotatedMember, BeanManager beanManager) {
            this.producer = producer;
            this.name = name;
            this.qualifiers = Beans.getQualifiers((BeanManager)beanManager, (Iterable)annotatedMember.getAnnotations());
        }

        Producer<Configuration> getProducer() {
            return this.producer;
        }

        String getName() {
            return this.name;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }
    }
}

